<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../config/database.php';

header('Content-Type: application/json');

try {
    error_log("Iniciando busca de clientes...");
    
    $database = new Database();
    $db = $database->getConnection();
    
    error_log("Conexão com banco estabelecida");
    
    // Primeiro verifica se a coluna existe
    $checkColumn = $db->query("SHOW COLUMNS FROM clientes LIKE 'data_nascimento'");
    $columnExists = $checkColumn->rowCount() > 0;
    
    error_log("Coluna data_nascimento existe: " . ($columnExists ? "sim" : "não"));
    
    // Monta a query baseada na existência da coluna
    $query = "SELECT 
        id,
        nome,
        " . ($columnExists ? "DATE_FORMAT(data_nascimento, '%d/%m/%Y')" : "NULL") . " as data_nascimento,
        endereco,
        numero,
        bairro,
        cidade,
        telefone,
        instagram
    FROM clientes 
    WHERE deleted_at IS NULL
    ORDER BY nome";
    
    error_log("Query: " . $query);
    
    $stmt = $db->prepare($query);
    $stmt->execute();
    $clientes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    error_log("Clientes encontrados: " . count($clientes));
    
    echo json_encode([
        'success' => true,
        'data' => $clientes,
        'columnExists' => $columnExists
    ]);
    
} catch (PDOException $e) {
    error_log("Erro de banco de dados: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro de banco de dados: ' . $e->getMessage(),
        'type' => 'database_error'
    ]);
} catch (Exception $e) {
    error_log("Erro geral: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao processar requisição: ' . $e->getMessage(),
        'type' => 'general_error'
    ]);
}
