<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    // Recebe o ID do cliente
    $id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
    
    if (!$id) {
        throw new Exception('ID do cliente não fornecido');
    }
    
    // Busca os dados do cliente
    $stmt = $pdo->prepare("
        SELECT 
            id,
            nome,
            DATE_FORMAT(data_nascimento, '%Y-%m-%d') as data_nascimento,
            endereco,
            numero,
            bairro,
            cidade,
            telefone,
            instagram
        FROM clientes 
        WHERE id = ?
    ");
    
    $stmt->execute([$id]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$cliente) {
        throw new Exception('Cliente não encontrado');
    }
    
    echo json_encode([
        'success' => true,
        'data' => $cliente
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
