<?php
header('Content-Type: application/json');

require_once '../config/conexao.php';
require_once '../includes/functions.php';

try {
    $pdo = getConnection();
    $pdo->beginTransaction();

    if (!isset($_POST['prova_id'])) {
        throw new Exception('ID da prova não fornecido');
    }

    $prova_id = $_POST['prova_id'];

    // Primeiro, busca os itens da prova
    $stmt = $pdo->prepare("
        SELECT produto_id, tamanho, quantidade 
        FROM operacao_itens 
        WHERE operacao_id = ?
    ");
    $stmt->execute([$prova_id]);
    $itens = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Para cada item, devolve ao estoque
    foreach ($itens as $item) {
        // Atualiza o estoque
        $stmt = $pdo->prepare("
            UPDATE produto_tamanhos 
            SET estoque = estoque + ? 
            WHERE produto_id = ? AND tamanho = ?
        ");
        $stmt->execute([
            $item['quantidade'],
            $item['produto_id'],
            $item['tamanho']
        ]);
    }

    // Marca a prova como convertida
    $stmt = $pdo->prepare("
        UPDATE operacoes 
        SET status = 'convertida', 
            updated_at = NOW() 
        WHERE id = ?
    ");
    $stmt->execute([$prova_id]);

    $pdo->commit();

    echo json_encode([
        'success' => true,
        'message' => 'Prova finalizada com sucesso'
    ]);

} catch (Exception $e) {
    if (isset($pdo)) {
        $pdo->rollBack();
    }
    
    error_log("Erro em finalizar_prova.php: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao finalizar prova: ' . $e->getMessage()
    ]);
}
