<?php
require_once '../includes/config.php';

try {
    // Configurações do backup
    $host = DB_HOST;
    $user = DB_USER;
    $pass = DB_PASS;
    $dbname = DB_NAME;

    // Nome do arquivo de backup
    $backup_file = '../backups/' . $dbname . '_' . date("Y-m-d_H-i-s") . '.sql';

    // Configurações do banco de dados
    $db = getConnection();
    
    // Cabeçalhos para download
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="backup_' . date('Y-m-d_H-i-s') . '.sql"');
    
    // Desativa verificações de chave estrangeira
    $output = "SET FOREIGN_KEY_CHECKS=0;\n\n";
    
    // Obtém todas as tabelas do banco
    $result = $db->query("SHOW TABLES");
    $tables = [];
    while ($row = $result->fetch(PDO::FETCH_NUM)) {
        $tables[] = $row[0];
    }
    
    // Log das tabelas encontradas
    $output .= "-- Tabelas encontradas no banco: " . implode(", ", $tables) . "\n\n";
    
    // Para cada tabela encontrada
    foreach ($tables as $table) {
        $output .= "-- Exportando tabela '$table'\n";
        
        // Adiciona comando DROP TABLE
        $output .= "DROP TABLE IF EXISTS `$table`;\n";
        
        // Obtém create table
        $stmt = $db->prepare("SHOW CREATE TABLE `" . str_replace('`', '``', $table) . "`");
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_NUM);
        if ($row) {
            $output .= $row[1] . ";\n\n";
            
            // Obtém dados
            $stmt = $db->prepare("SELECT * FROM `" . str_replace('`', '``', $table) . "`");
            $stmt->execute();
            $numColumns = $stmt->columnCount();
            
            while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
                $output .= "INSERT INTO `$table` VALUES(";
                for ($j = 0; $j < $numColumns; $j++) {
                    if (isset($row[$j])) {
                        // Escapa aspas e caracteres especiais
                        $value = str_replace(
                            ['\\', "\0", "\n", "\r", "'", '"', "\x1a"],
                            ['\\\\', '\\0', '\\n', '\\r', "\\'", '\\"', '\\Z'],
                            $row[$j]
                        );
                        $output .= '"' . $value . '"';
                    } else {
                        $output .= 'NULL';
                    }
                    if ($j < ($numColumns - 1)) {
                        $output .= ',';
                    }
                }
                $output .= ");\n";
            }
            $output .= "\n";
        }
    }
    
    // Reativa verificações de chave estrangeira
    $output .= "\nSET FOREIGN_KEY_CHECKS=1;\n";
    
    echo $output;
    
} catch (Exception $e) {
    // Em caso de erro, ainda retorna um arquivo SQL válido com comentário
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="backup_error_' . date('Y-m-d_H-i-s') . '.sql"');
    echo "-- Erro durante o backup: " . $e->getMessage() . "\n";
    echo "-- Data: " . date('Y-m-d H:i:s') . "\n";
}
