<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

try {
    $pdo = getConnection();
    
    // SQL para criar a tabela operacoes
    $sql_operacoes = "
    CREATE TABLE IF NOT EXISTS operacoes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        cliente_id INT NOT NULL,
        tipo ENUM('venda', 'prova') NOT NULL,
        valor_total DECIMAL(10,2) NOT NULL,
        created_at DATETIME NOT NULL,
        updated_at DATETIME NULL,
        deleted_at DATETIME NULL,
        FOREIGN KEY (cliente_id) REFERENCES clientes(id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ";

    // SQL para criar a tabela operacao_itens
    $sql_itens = "
    CREATE TABLE IF NOT EXISTS operacao_itens (
        id INT AUTO_INCREMENT PRIMARY KEY,
        operacao_id INT NOT NULL,
        produto_id INT NOT NULL,
        tamanho VARCHAR(10) NOT NULL,
        quantidade INT NOT NULL,
        valor_unitario DECIMAL(10,2) NOT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME NULL,
        deleted_at DATETIME NULL,
        FOREIGN KEY (operacao_id) REFERENCES operacoes(id),
        FOREIGN KEY (produto_id) REFERENCES produtos(id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ";

    // Executa os comandos SQL
    $pdo->exec($sql_operacoes);
    echo "Tabela 'operacoes' criada com sucesso!<br>";
    
    $pdo->exec($sql_itens);
    echo "Tabela 'operacao_itens' criada com sucesso!<br>";

} catch (PDOException $e) {
    die("Erro ao criar tabelas: " . $e->getMessage());
}
