<?php
// Desativa a exibição de erros
error_reporting(0);
ini_set('display_errors', 0);

// Garante que nenhum output foi enviado antes
if (ob_get_length()) ob_clean();

header('Content-Type: application/json');

require_once '../includes/config.php';
require_once '../includes/functions.php';

try {
    if (!isset($_POST['id'])) {
        throw new Exception('ID da venda não fornecido');
    }

    $vendaId = $_POST['id'];
    $pdo = getConnection();
    
    // Inicia transação
    $pdo->beginTransaction();
    
    // Busca itens da venda
    $query = "
        SELECT produto_id, tamanho, quantidade
        FROM operacao_itens
        WHERE operacao_id = ?
        AND deleted_at IS NULL
    ";
    $stmt = $pdo->prepare($query);
    $stmt->execute([$vendaId]);
    $itens = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Devolve estoque para cada item
    foreach ($itens as $item) {
        $queryEstoque = "
            UPDATE produto_tamanhos
            SET estoque = estoque + ?
            WHERE produto_id = ?
            AND tamanho = ?
        ";
        $stmtEstoque = $pdo->prepare($queryEstoque);
        $stmtEstoque->execute([$item['quantidade'], $item['produto_id'], $item['tamanho']]);
    }
    
    // Marca venda como cancelada (soft delete)
    $queryVenda = "
        UPDATE operacoes
        SET deleted_at = NOW()
        WHERE id = ?
    ";
    $stmtVenda = $pdo->prepare($queryVenda);
    $stmtVenda->execute([$vendaId]);
    
    // Marca itens como cancelados (soft delete)
    $queryItens = "
        UPDATE operacao_itens
        SET deleted_at = NOW()
        WHERE operacao_id = ?
    ";
    $stmtItens = $pdo->prepare($queryItens);
    $stmtItens->execute([$vendaId]);
    
    // Confirma transação
    $pdo->commit();
    
    die(json_encode([
        'success' => true,
        'message' => 'Venda cancelada com sucesso!'
    ]));

} catch (Exception $e) {
    if (isset($pdo)) {
        $pdo->rollBack();
    }
    
    die(json_encode([
        'success' => false,
        'message' => 'Erro ao cancelar venda: ' . $e->getMessage()
    ]));
}
