<?php
require_once '../includes/config.php';
require_once '../includes/conexao.php';

// Verifica se o usuário está logado
session_start();
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../admin/login.php');
    exit;
}

try {
    // Verifica se já existe um caixa aberto
    $stmt = $pdo->prepare("SELECT id FROM caixa WHERE status = 'aberto'");
    $stmt->execute();
    if ($stmt->fetch()) {
        throw new Exception('Já existe um caixa aberto');
    }

    // Valida o valor de abertura
    if (!isset($_POST['valor_abertura']) || !is_numeric($_POST['valor_abertura'])) {
        throw new Exception('Valor de abertura inválido');
    }

    // Insere o novo registro
    $stmt = $pdo->prepare("INSERT INTO caixa (status, valor_abertura, data_abertura, usuario_id, observacao) VALUES ('aberto', ?, NOW(), ?, ?)");
    $stmt->execute([
        $_POST['valor_abertura'],
        $_SESSION['usuario_id'],
        $_POST['observacao'] ?? null
    ]);

    $_SESSION['success'] = 'Caixa aberto com sucesso!';
} catch (Exception $e) {
    $_SESSION['error'] = $e->getMessage();
}

header('Location: ../caixa.php');
exit;
