<?php
require_once 'includes/verificar_permissao.php';
verificarPermissao(__FILE__);
?>
<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

$pageTitle = "Vendas";
include 'includes/header.php';
?>

<div class="wrapper">
    <!-- Sidebar -->
    <?php require_once 'includes/sidebar.php'; ?>

    <!-- Page Content -->
    <div id="content">
        <!-- Navbar -->
        <nav class="navbar navbar-expand-lg bg-white">
            <div class="container-fluid">
                <h2 class="navbar-title">Vendas</h2>
                <div class="ms-auto">
                </div>
            </nav>

            <div class="container-fluid content-area">
                <div class="card mb-4">
                    <div class="card-body">
                        <form id="filtroVendas" class="row g-3 mb-4">
                            <div class="col-md-2">
                                <label for="filtroId" class="form-label">ID da Venda</label>
                                <input type="text" class="form-control" id="filtroId" placeholder="ID">
                            </div>
                            <div class="col-md-2">
                                <label for="filtroCliente" class="form-label">Nome do Cliente</label>
                                <input type="text" class="form-control" id="filtroCliente" placeholder="Nome do cliente">
                            </div>
                            <div class="col-md-2">
                                <label for="filtroData" class="form-label">Data da Compra</label>
                                <input type="date" class="form-control" id="filtroData">
                            </div>
                            <div class="col-md-2">
                                <label for="filtroMetodo" class="form-label">Método de Pagamento</label>
                                <select class="form-select" id="filtroMetodo">
                                    <option value="">Todos</option>
                                    <option value="Dinheiro">Dinheiro</option>
                                    <option value="Cartão de Crédito">Cartão de Crédito</option>
                                    <option value="Cartão de Débito">Cartão de Débito</option>
                                    <option value="PIX">PIX</option>
                                    <option value="Crediário">Crediário</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="filtroValor" class="form-label">Valor</label>
                                <input type="number" class="form-control" id="filtroValor" placeholder="R$ 0,00" step="0.01">
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="button" class="btn btn-primary me-2" id="btnFiltrar">Filtrar</button>
                                <button type="button" class="btn btn-secondary" id="btnLimparFiltro">Limpar</button>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Cliente</th>
                                        <th>Data/Hora</th>
                                        <th>Método de Pagamento</th>
                                        <th>Valor Total</th>
                                        <th>A Receber</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody id="vendasTableBody">
                                    <!-- Dados serão carregados via JavaScript -->
                                </tbody>
                            </table>
                        </div>
                        <!-- Paginação -->
                        <nav aria-label="Navegação de página">
                            <ul class="pagination justify-content-end" id="pagination">
                                <!-- Paginação será carregada via JavaScript -->
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Impressão -->
    <div class="modal fade" id="modalImpressao" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header justify-content-center">
                    <h5 class="modal-title text-center">Cupom de Venda</h5>
                </div>
                <div class="modal-body">
                    <div id="cupomContent" style="font-family: 'Courier New', monospace;">
                        <!-- Conteúdo do cupom será carregado via JavaScript -->
                    </div>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnImprimirCupom">Imprimir</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Cancelamento -->
    <div class="modal fade" id="modalCancelarVenda" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Confirmar Cancelamento</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Tem certeza que deseja cancelar esta venda? Esta ação não pode ser desfeita.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                    <button type="button" class="btn btn-danger" id="btnConfirmarCancelamento">Sim, Cancelar Venda</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Pagamento Parcial -->
    <div class="modal fade" id="modalPagamentoParcial" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Pagamento Parcial</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <h6 style="color: var(--text-color);">Valor Total da Venda</h6>
                            <p class="h4" id="valorTotalVenda">R$ 0,00</p>
                        </div>
                        <div class="col-md-6">
                            <h6 style="color: var(--text-color);">Valor Restante</h6>
                            <p class="h4" id="valorRestante">R$ 0,00</p>
                        </div>
                    </div>

                    <form id="formPagamentoParcial">
                        <input type="hidden" name="venda_id" id="vendaId">
                        <div class="mb-3">
                            <label for="valorPagamento" class="form-label" style="color: var(--text-color);">Valor do Pagamento</label>
                            <div class="input-group">
                                <span class="input-group-text">R$</span>
                                <input type="text" class="form-control money" id="valorPagamento" name="valor" required>
                            </div>
                        </div>
                    </form>

                    <div class="mt-4">
                        <h6 style="color: var(--text-color);">Histórico de Pagamentos</h6>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Data/Hora</th>
                                        <th>Valor Pago</th>
                                    </tr>
                                </thead>
                                <tbody id="historicoPagamentos">
                                    <!-- Preenchido via JavaScript -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    <button type="submit" form="formPagamentoParcial" class="btn btn-primary">Registrar Pagamento</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Toast Container -->
    <div class="toast-container position-fixed bottom-0 end-0 p-3"></div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/vendas.js"></script>
</body>
</html>
