<?php
require_once 'includes/verificar_permissao.php';
verificarPermissao(__FILE__);
?>
<?php
$pageTitle = "Usuários";
require_once 'includes/config.php';
require_once 'includes/auth.php';
include 'includes/header.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: login.php');
    exit;
}
?>

<div class="wrapper">
    <!-- Sidebar -->
    <?php require_once 'includes/sidebar.php'; ?>

    <!-- Content -->
    <div id="content">
        <!-- Navbar -->
        <nav class="navbar navbar-expand-lg bg-white">
            <div class="container-fluid">
                <h2 class="navbar-title">Usuários</h2>
                <div class="ms-auto">
                    <button type="button" class="btn btn-primary" onclick="limparFormulario()">
                        <i class="bi bi-plus-lg"></i> Novo Usuário
                    </button>
                </div>
            </div>
        </nav>

        <div class="container-fluid content-area">
            <!-- Formulário de Cadastro -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-white py-3">
                    <h5 class="card-title fw-bold mb-0">
                        <i class="bi bi-person-plus"></i> <span id="formTitle">Novo Usuário</span>
                    </h5>
                </div>
                <div class="card-body">
                    <form id="formUsuario" method="post" class="needs-validation" novalidate>
                        <input type="hidden" id="usuario_id" name="id">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="nome" class="form-label fw-semibold">Nome do Usuário</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-person"></i></span>
                                    <input type="text" class="form-control" id="nome" name="nome" required>
                                </div>
                                <div class="invalid-feedback">
                                    Por favor, informe o nome do usuário.
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <label for="senha" class="form-label fw-semibold">Senha</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-key"></i></span>
                                    <input type="password" class="form-control" id="senha" name="senha" required>
                                </div>
                                <div class="invalid-feedback">
                                    Por favor, informe uma senha.
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <label for="confirmar_senha" class="form-label fw-semibold">Confirmar Senha</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-key-fill"></i></span>
                                    <input type="password" class="form-control" id="confirmar_senha" name="confirmar_senha" required>
                                </div>
                                <div class="invalid-feedback">
                                    As senhas não coincidem.
                                </div>
                            </div>
                        </div>

                        <div class="mt-4">
                            <label class="form-label fw-semibold mb-3">
                                <i class="bi bi-shield-lock"></i> Permissões de Menu
                            </label>
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissoes[]" value="dashboard" id="perm_dashboard">
                                        <label class="form-check-label" for="perm_dashboard">
                                            <i class="bi bi-speedometer2"></i> Dashboard
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissoes[]" value="clientes" id="perm_clientes">
                                        <label class="form-check-label" for="perm_clientes">
                                            <i class="bi bi-people"></i> Clientes
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissoes[]" value="produtos" id="perm_produtos">
                                        <label class="form-check-label" for="perm_produtos">
                                            <i class="bi bi-box"></i> Produtos
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissoes[]" value="pdv" id="perm_pdv">
                                        <label class="form-check-label" for="perm_pdv">
                                            <i class="bi bi-cart"></i> PDV
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissoes[]" value="caixa" id="perm_caixa">
                                        <label class="form-check-label" for="perm_caixa">
                                            <i class="bi bi-cash-stack"></i> Caixa
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissoes[]" value="vendas" id="perm_vendas">
                                        <label class="form-check-label" for="perm_vendas">
                                            <i class="bi bi-graph-up"></i> Vendas
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissoes[]" value="relatorios" id="perm_relatorios">
                                        <label class="form-check-label" for="perm_relatorios">
                                            <i class="bi bi-file-earmark-text"></i> Relatórios
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissoes[]" value="configuracoes" id="perm_configuracoes">
                                        <label class="form-check-label" for="perm_configuracoes">
                                            <i class="bi bi-gear"></i> Configurações
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissoes[]" value="provas" id="perm_provas">
                                        <label class="form-check-label" for="perm_provas">
                                            <i class="bi bi-file-earmark-text"></i> Provas
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-4 text-end">
                            <button type="button" class="btn btn-secondary me-2" onclick="limparFormulario()">
                                <i class="bi bi-x-lg"></i> Cancelar
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-lg"></i> Salvar Usuário
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Listagem de Usuários -->
            <div class="card shadow-sm">
                <div class="card-header bg-white py-3">
                    <h5 class="card-title fw-bold mb-0">
                        <i class="bi bi-people"></i> Usuários Cadastrados
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>Permissões</th>
                                    <th class="text-end">Ações</th>
                                </tr>
                            </thead>
                            <tbody id="listaUsuarios">
                                <!-- Preenchido via JavaScript -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Modal de Confirmação -->
            <div class="modal fade" id="modalConfirmacao" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Confirmar Exclusão</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <p>Tem certeza que deseja excluir este usuário?</p>
                            <input type="hidden" id="id_exclusao">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                            <button type="button" class="btn btn-danger" onclick="excluirUsuario()">
                                <i class="bi bi-trash"></i> Excluir
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Toast de Notificação -->
            <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 11">
                <div id="notificationToast" class="toast align-items-center text-white border-0" role="alert" aria-live="assertive" aria-atomic="true">
                    <div class="d-flex">
                        <div class="toast-body">
                            <i class="bi bi-info-circle me-2"></i>
                            <span id="toastMessage"></span>
                        </div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Variáveis globais
let usuarioParaExcluir = null;
let confirmModal = null;

// Inicializar modal quando o documento estiver pronto
document.addEventListener('DOMContentLoaded', function() {
    confirmModal = new bootstrap.Modal(document.getElementById('modalConfirmacao'));
    
    // Configurar evento de clique no botão de confirmar exclusão
    document.getElementById('btnConfirmarExclusao').addEventListener('click', excluirUsuario);
    
    // Carregar lista inicial de usuários
    carregarUsuarios();
});

// Função para confirmar exclusão
function confirmarExclusao(id) {
    console.log('Confirmando exclusão do usuário:', id);
    document.getElementById('id_exclusao').value = id;
    const modal = new bootstrap.Modal(document.getElementById('modalConfirmacao'));
    modal.show();
}

// Função para excluir usuário
function excluirUsuario() {
    const id = document.getElementById('id_exclusao').value;
    console.log('Executando exclusão do usuário:', id);
    
    if (!id) {
        console.error('ID do usuário não encontrado');
        return;
    }
    
    const formData = new FormData();
    formData.append('id', id);
    
    fetch('actions/excluir_usuario.php', {
        method: 'POST',
        body: formData
    })
    .then(response => {
        console.log('Resposta recebida:', response);
        return response.json();
    })
    .then(data => {
        console.log('Dados da exclusão:', data);
        const modal = bootstrap.Modal.getInstance(document.getElementById('modalConfirmacao'));
        modal.hide();
        
        showNotification(data.message, data.success);
        if (data.success) {
            carregarUsuarios();
        }
    })
    .catch(error => {
        console.error('Erro ao excluir:', error);
        const modal = bootstrap.Modal.getInstance(document.getElementById('modalConfirmacao'));
        modal.hide();
        showNotification('Erro ao excluir usuário: ' + error.message, false);
    });
}

// Limpar usuário para exclusão quando o modal for fechado
document.getElementById('modalConfirmacao').addEventListener('hidden.bs.modal', function () {
    document.getElementById('id_exclusao').value = '';
});

// Carregar lista de usuários
function carregarUsuarios() {
    fetch('actions/listar_usuarios.php')
        .then(response => {
            if (!response.ok) {
                throw new Error('Erro na resposta do servidor');
            }
            return response.json();
        })
        .then(data => {
            console.log('Dados recebidos:', data);
            if (data.success) {
                const tbody = document.getElementById('listaUsuarios');
                tbody.innerHTML = '';
                
                data.usuarios.forEach(usuario => {
                    console.log('Processando usuário:', usuario);
                    let permissoes = [];
                    try {
                        permissoes = JSON.parse(usuario.permissoes || '[]');
                    } catch (e) {
                        console.error('Erro ao parsear permissões:', e);
                        permissoes = [];
                    }
                    
                    const tr = document.createElement('tr');
                    tr.innerHTML = `
                        <td>${usuario.nome || ''}</td>
                        <td>
                            <div class="d-flex flex-wrap gap-1">
                                ${permissoes.map(p => `
                                    <span class="badge bg-secondary">${p}</span>
                                `).join('')}
                            </div>
                        </td>
                        <td class="text-end">
                            <button type="button" class="btn btn-sm btn-primary btn-editar-usuario" 
                                data-id="${usuario.id}" 
                                data-nome="${usuario.nome || ''}" 
                                data-permissoes='${usuario.permissoes || "[]"}'>
                                <i class="bi bi-pencil"></i>
                            </button>
                            <button type="button" class="btn btn-sm btn-danger" onclick="confirmarExclusao(${usuario.id})">
                                <i class="bi bi-trash"></i>
                            </button>
                        </td>
                    `;
                    tbody.appendChild(tr);
                });

                // Adicionar event listeners aos botões de editar
                document.querySelectorAll('.btn-editar-usuario').forEach(btn => {
                    btn.addEventListener('click', function() {
                        const id = this.getAttribute('data-id');
                        const nome = this.getAttribute('data-nome');
                        const permissoes = this.getAttribute('data-permissoes');
                        editarUsuario(id, nome, permissoes);
                    });
                });
            } else {
                console.error('Erro nos dados:', data);
                showNotification(data.message || 'Erro ao carregar usuários', false);
            }
        })
        .catch(error => {
            console.error('Erro ao carregar usuários:', error);
            showNotification('Erro ao carregar usuários: ' + error.message, false);
        });
}

// Função para editar usuário
function editarUsuario(id, nome, permissoes) {
    console.log('Editando usuário:', { id, nome, permissoes });
    
    document.getElementById('usuario_id').value = id;
    document.getElementById('nome').value = nome;
    document.getElementById('formTitle').textContent = 'Editar Usuário';
    
    // Limpar todas as checkboxes
    document.querySelectorAll('input[name="permissoes[]"]').forEach(checkbox => {
        checkbox.checked = false;
    });
    
    try {
        // Tentar fazer o parse das permissões
        const permissoesArray = JSON.parse(permissoes);
        console.log('Permissões parseadas:', permissoesArray);
        
        // Marcar as permissões do usuário
        if (Array.isArray(permissoesArray)) {
            permissoesArray.forEach(permissao => {
                const checkbox = document.querySelector(`input[name="permissoes[]"][value="${permissao}"]`);
                console.log('Checkbox para permissão', permissao, checkbox);
                if (checkbox) checkbox.checked = true;
            });
        }
    } catch (error) {
        console.error('Erro ao processar permissões:', error);
    }
    
    // Mostrar campos de senha como opcionais
    document.getElementById('senha').removeAttribute('required');
    document.getElementById('confirmar_senha').removeAttribute('required');
    
    // Scroll para o formulário
    document.querySelector('.card').scrollIntoView({ behavior: 'smooth' });
}

// Função para limpar formulário
function limparFormulario() {
    document.getElementById('formUsuario').reset();
    document.getElementById('usuario_id').value = '';
    document.getElementById('formTitle').textContent = 'Novo Usuário';
    document.getElementById('senha').setAttribute('required', '');
    document.getElementById('confirmar_senha').setAttribute('required', '');
    document.getElementById('formUsuario').classList.remove('was-validated');
}

// Validação do formulário e envio
document.getElementById('formUsuario').addEventListener('submit', function(event) {
    event.preventDefault();
    event.stopPropagation();
    
    if (!this.checkValidity()) {
        this.classList.add('was-validated');
        return;
    }
    
    // Verificar senhas apenas para novo usuário
    if (!document.getElementById('usuario_id').value) {
        const senha = document.getElementById('senha').value;
        const confirmarSenha = document.getElementById('confirmar_senha').value;
        
        if (senha !== confirmarSenha) {
            document.getElementById('confirmar_senha').setCustomValidity('As senhas não coincidem');
            this.classList.add('was-validated');
            return;
        }
    }
    
    // Enviar formulário
    const formData = new FormData(this);
    
    fetch('actions/salvar_usuario.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        showNotification(data.message, data.success);
        if (data.success) {
            limparFormulario();
            carregarUsuarios();
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        showNotification('Erro ao salvar usuário', false);
    });
});

// Função para mostrar notificação
function showNotification(message, success = true) {
    const toast = document.getElementById('notificationToast');
    document.getElementById('toastMessage').textContent = message;
    
    toast.classList.remove('bg-success', 'bg-danger');
    toast.classList.add(success ? 'bg-success' : 'bg-danger');
    
    const bsToast = new bootstrap.Toast(toast);
    bsToast.show();
}
</script>

<?php include 'includes/footer.php'; ?>
