<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

echo "<h2>Teste de Sessão</h2>";
echo "<pre>";

// Informações da Sessão
echo "Session ID: " . session_id() . "\n";
echo "Session Save Path: " . session_save_path() . "\n";
echo "Session Status: " . session_status() . "\n";

// Testar gravação na sessão
$_SESSION['test'] = 'teste_' . time();
echo "\nGravou na sessão: " . $_SESSION['test'] . "\n";

// Verificar todas as variáveis de sessão
echo "\nVariáveis de Sessão:\n";
print_r($_SESSION);

// Testar includes principais
echo "\nTestando includes principais:\n";
$includes = [
    'includes/config.php',
    'includes/auth.php',
    'includes/conexao.php'
];

foreach ($includes as $file) {
    if (file_exists($file)) {
        echo "$file: Existe\n";
        // Tenta incluir
        try {
            include_once $file;
            echo "- Incluído com sucesso\n";
        } catch (Exception $e) {
            echo "- Erro ao incluir: " . $e->getMessage() . "\n";
        }
    } else {
        echo "$file: Não existe\n";
    }
}

// Verificar .htaccess
echo "\nConteúdo do .htaccess (se existir):\n";
if (file_exists('.htaccess')) {
    echo file_get_contents('.htaccess');
} else {
    echo ".htaccess não encontrado";
}

// Verificar installed.txt
echo "\nConteúdo do installed.txt:\n";
if (file_exists('installed.txt')) {
    echo file_get_contents('installed.txt');
} else {
    echo "installed.txt não encontrado";
}

// Verificar permissões de arquivos importantes
echo "\nPermissões de arquivos importantes:\n";
$important_files = [
    'index.php',
    'login.php',
    'includes/config.php',
    'includes/auth.php',
    'includes/conexao.php'
];

foreach ($important_files as $file) {
    if (file_exists($file)) {
        echo "$file: " . substr(sprintf('%o', fileperms($file)), -4) . "\n";
    } else {
        echo "$file: Não existe\n";
    }
}
