-- Script para limpar os dados do sistema mantendo apenas o essencial

-- Desabilitar verificação de chaves estrangeiras
SET FOREIGN_KEY_CHECKS = 0;

-- Limpar tabela de vendas e relacionadas
TRUNCATE TABLE vendas_itens;
TRUNCATE TABLE vendas;
TRUNCATE TABLE pagamentos;
TRUNCATE TABLE pagamentos_crediario;
TRUNCATE TABLE operacoes;

-- Limpar tabela de produtos e relacionadas
TRUNCATE TABLE produtos;
TRUNCATE TABLE categorias;
TRUNCATE TABLE estoque_movimentacao;

-- Limpar tabela de clientes
TRUNCATE TABLE clientes;

-- Limpar dados do caixa
TRUNCATE TABLE caixa;
TRUNCATE TABLE caixa_movimentacao;

-- Limpar outras tabelas
TRUNCATE TABLE marketing_campanhas;
TRUNCATE TABLE provas;
TRUNCATE TABLE provas_detalhes;

-- Habilitar verificação de chaves estrangeiras
SET FOREIGN_KEY_CHECKS = 1;

-- Resetar auto_increment das tabelas principais
ALTER TABLE vendas AUTO_INCREMENT = 1;
ALTER TABLE produtos AUTO_INCREMENT = 1;
ALTER TABLE clientes AUTO_INCREMENT = 1;
ALTER TABLE categorias AUTO_INCREMENT = 1;
ALTER TABLE operacoes AUTO_INCREMENT = 1;
ALTER TABLE caixa AUTO_INCREMENT = 1;
