-- Verifica se a coluna tamanho existe
SHOW COLUMNS FROM produtos LIKE 'tamanho';

-- Mostra os tamanhos atuais
SELECT id, nome, tamanho FROM produtos WHERE deleted_at IS NULL;

-- Adiciona a coluna tamanho se não existir
ALTER TABLE produtos ADD COLUMN IF NOT EXISTS tamanho VARCHAR(50) DEFAULT NULL COMMENT 'Tamanho do produto';

-- Atualiza alguns produtos com tamanhos para teste (ajuste conforme necessário)
UPDATE produtos SET tamanho = 'P' WHERE id = 1 AND tamanho IS NULL;
UPDATE produtos SET tamanho = 'M' WHERE id = 2 AND tamanho IS NULL;
UPDATE produtos SET tamanho = 'G' WHERE id = 3 AND tamanho IS NULL;
