-- Adiciona a coluna valor_total se ela não existir
ALTER TABLE caixa ADD COLUMN IF NOT EXISTS valor_total DECIMAL(10,2) DEFAULT 0.00;

-- Atualiza a estrutura da tabela vendas
DROP TABLE IF EXISTS vendas;
CREATE TABLE vendas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    operacao_id INT,
    usuario_id INT,
    cliente_id INT,
    valor_total DECIMAL(10,2) NOT NULL,
    data_venda DATETIME NOT NULL,
    status VARCHAR(50) DEFAULT 'concluida',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (operacao_id) REFERENCES operacoes(id) ON DELETE CASCADE
);

-- Cria a tabela pagamentos_crediario se não existir
DROP TABLE IF EXISTS pagamentos_crediario;
CREATE TABLE pagamentos_crediario (
    id INT AUTO_INCREMENT PRIMARY KEY,
    venda_id INT,
    valor_pago DECIMAL(10,2) NOT NULL,
    data_pagamento DATETIME NOT NULL,
    usuario_id INT,
    cliente_id INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (venda_id) REFERENCES operacoes(id) ON DELETE CASCADE
);
