-- Adiciona a coluna status se não existir
SET @exist := (SELECT COUNT(*) 
               FROM information_schema.COLUMNS 
               WHERE TABLE_SCHEMA = 'garota' 
               AND TABLE_NAME = 'produtos' 
               AND COLUMN_NAME = 'status');

SET @query := IF(@exist = 0,
    'ALTER TABLE produtos ADD COLUMN status TINYINT(1) DEFAULT 1 COMMENT "Status do produto (1=ativo, 0=inativo)"',
    'SELECT "Coluna status já existe"');

PREPARE stmt FROM @query;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Adiciona a coluna preco se não existir
SET @exist := (SELECT COUNT(*) 
               FROM information_schema.COLUMNS 
               WHERE TABLE_SCHEMA = 'garota' 
               AND TABLE_NAME = 'produtos' 
               AND COLUMN_NAME = 'preco');

SET @query := IF(@exist = 0,
    'ALTER TABLE produtos ADD COLUMN preco DECIMAL(10,2) DEFAULT 0.00 COMMENT "Preço do produto"',
    'SELECT "Coluna preco já existe"');

PREPARE stmt FROM @query;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Adiciona a coluna cor se não existir
SET @exist := (SELECT COUNT(*) 
               FROM information_schema.COLUMNS 
               WHERE TABLE_SCHEMA = 'garota' 
               AND TABLE_NAME = 'produtos' 
               AND COLUMN_NAME = 'cor');

SET @query := IF(@exist = 0,
    'ALTER TABLE produtos ADD COLUMN cor VARCHAR(50) DEFAULT NULL COMMENT "Cor do produto"',
    'SELECT "Coluna cor já existe"');

PREPARE stmt FROM @query;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Adiciona a coluna tamanhos se não existir
SET @exist := (SELECT COUNT(*) 
               FROM information_schema.COLUMNS 
               WHERE TABLE_SCHEMA = 'garota' 
               AND TABLE_NAME = 'produtos' 
               AND COLUMN_NAME = 'tamanhos');

SET @query := IF(@exist = 0,
    'ALTER TABLE produtos ADD COLUMN tamanhos VARCHAR(255) DEFAULT NULL COMMENT "Tamanhos disponíveis separados por vírgula"',
    'SELECT "Coluna tamanhos já existe"');

PREPARE stmt FROM @query;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
