<?php
require_once 'includes/config.php';

try {
    $pdo = getConnection();
    
    // Array para armazenar mensagens de status
    $messages = [];
    
    // 1. Criar tabela pagamentos_parciais
    $sql = "
    CREATE TABLE IF NOT EXISTS pagamentos_parciais (
        id INT AUTO_INCREMENT PRIMARY KEY,
        venda_id INT NOT NULL,
        valor DECIMAL(10,2) NOT NULL,
        data_pagamento DATETIME NOT NULL,
        FOREIGN KEY (venda_id) REFERENCES vendas(id)
    )";
    
    $pdo->exec($sql);
    $messages[] = "✓ Tabela 'pagamentos_parciais' criada ou já existe";
    
    // 2. Adicionar coluna status na tabela vendas
    // Primeiro verifica se a coluna já existe
    $result = $pdo->query("SHOW COLUMNS FROM vendas LIKE 'status'");
    if ($result->rowCount() == 0) {
        $sql = "ALTER TABLE vendas ADD COLUMN status VARCHAR(20) DEFAULT NULL";
        $pdo->exec($sql);
        $messages[] = "✓ Coluna 'status' adicionada à tabela 'vendas'";
    } else {
        $messages[] = "✓ Coluna 'status' já existe na tabela 'vendas'";
    }
    
    // 3. Atualizar vendas existentes no crediário para status NULL
    $sql = "UPDATE vendas SET status = NULL WHERE metodo_pagamento = 'Crediário'";
    $stmt = $pdo->exec($sql);
    $messages[] = "✓ Status das vendas no crediário atualizado";
    
    // Exibe mensagens de sucesso
    echo "<h2>Setup do Sistema de Pagamentos Parciais</h2>";
    echo "<div style='font-family: Arial, sans-serif; padding: 20px;'>";
    foreach ($messages as $message) {
        echo "<p style='color: green;'>{$message}</p>";
    }
    echo "<p style='margin-top: 20px;'><strong>Setup concluído com sucesso!</strong></p>";
    echo "</div>";
    
} catch (PDOException $e) {
    echo "<div style='font-family: Arial, sans-serif; padding: 20px;'>";
    echo "<p style='color: red;'>Erro durante o setup: " . $e->getMessage() . "</p>";
    echo "</div>";
}
