<?php
require_once 'includes/verificar_permissao.php';
verificarPermissao(__FILE__);
?>
<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

$pageTitle = "Relatórios";
include 'includes/header.php';
?>

<div class="wrapper">
    <!-- Sidebar -->
    <?php require_once 'includes/sidebar.php'; ?>

    <!-- Page Content -->
    <div id="content">
        <!-- Navbar -->
        <nav class="navbar navbar-expand-lg bg-white">
            <div class="container-fluid">
                <h2 class="navbar-title">Relatórios</h2>
            </div>
        </nav>

        <div class="container-fluid content-area">
            <!-- Filtros -->
            <div class="card mb-4">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Período</label>
                            <input type="text" class="form-control" id="periodo" name="periodo">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Cliente</label>
                            <select class="form-select select2" id="cliente" name="cliente">
                                <option value="">Todos os clientes</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Produto</label>
                            <select class="form-select select2" id="produto" name="produto">
                                <option value="">Todos os produtos</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Tipo de Operação</label>
                            <select class="form-select" id="tipoOperacao" name="tipoOperacao">
                                <option value="">Todas</option>
                                <option value="venda">Vendas</option>
                                <option value="prova">Provas</option>
                            </select>
                        </div>
                    </div>
                    <div class="text-end">
                        <button class="btn btn-primary" id="btnFiltrar">
                            <i class="bi bi-funnel"></i> Filtrar
                        </button>
                    </div>
                </div>
            </div>

            <!-- Cards de Resumo -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-subtitle mb-2 text-muted">Total de Vendas</h6>
                            <h3 class="card-title" id="totalVendas">R$ 0,00</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-subtitle mb-2 text-muted">Quantidade de Vendas</h6>
                            <h3 class="card-title" id="qtdVendas">0</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-subtitle mb-2 text-muted">Ticket Médio</h6>
                            <h3 class="card-title" id="ticketMedio">R$ 0,00</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-subtitle mb-2 text-muted">Provas Convertidas</h6>
                            <h3 class="card-title" id="provasConvertidas">0%</h3>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gráficos -->
            <div class="row mb-4">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Vendas por Período</h5>
                            <canvas id="vendasPorPeriodo"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Produtos Mais Vendidos</h5>
                            <canvas id="produtosMaisVendidos"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Vendas por Forma de Pagamento</h5>
                            <canvas id="vendasPorPagamento"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Melhores Clientes</h5>
                            <canvas id="melhoresClientes"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Toast Container -->
<div class="toast-container position-fixed bottom-0 end-0 p-3"></div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="assets/js/sidebar.js"></script>
<script src="assets/js/toast.js"></script>
<script src="assets/js/relatorios.js"></script>
