<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Redireciona para a loja se o site estiver ativo
$config = getSiteConfig();
if ($config['site_ativo'] == 1) {
    header('Location: /garota/loja');
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Desativado</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #f8f9fa;
        }
        .maintenance-container {
            text-align: center;
            padding: 2rem;
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            max-width: 500px;
            width: 90%;
        }
        .icon-large {
            font-size: 4rem;
            color: #dc3545;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="maintenance-container">
        <i class="fas fa-exclamation-circle icon-large"></i>
        <h2 class="mb-4">Site Temporariamente Indisponível</h2>
        <p class="lead mb-4">O site está temporariamente desativado para manutenção. Por favor, tente novamente mais tarde.</p>
        <p class="text-muted">Se você é o administrador, ative o site em Configurações.</p>
    </div>
</body>
</html>
