<?php
// Carrega configurações da empresa
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

try {
    $pdo = getConnection();
    
    // Busca o nome da empresa da tabela config_empresa
    $stmt = $pdo->query("SELECT nome_empresa FROM config_empresa LIMIT 1");
    $config_empresa = $stmt->fetch(PDO::FETCH_ASSOC);
    $empresa_nome = $config_empresa['nome_empresa'];
    
} catch (Exception $e) {
    error_log("Erro ao buscar configurações da empresa: " . $e->getMessage());
    $empresa_nome = '';
}

// Formata o nome da empresa se existir
if (!empty($empresa_nome)) {
    $empresa_nome = ucwords(mb_strtolower($empresa_nome, 'UTF-8'));
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../favicon.png">
    <link rel="shortcut icon" type="image/png" href="../favicon.png">
    <title><?php echo formatPageTitle(isset($pageTitle) ? $pageTitle : ''); ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="css/style.css" rel="stylesheet">
</head>
