<?php
// Footer template
// Debug temporário
error_log("DEBUG - Configurações da empresa no footer: " . print_r($config_empresa, true));
?>
<!-- Footer -->
<footer class="footer mt-5 py-4">
    <div class="container">
        <div class="row g-4">
            <div class="col-12 col-md-4">
                <h5>Endereço</h5>
                <address>
                    <?php if (!empty($config_empresa['endereco'])): ?>
                        <p class="mb-1">
                            <i class="bi bi-geo-alt-fill"></i> 
                            <?php echo htmlspecialchars($config_empresa['endereco']); ?>
                            <?php echo !empty($config_empresa['numero']) ? ', ' . htmlspecialchars($config_empresa['numero']) : ''; ?>
                        </p>
                    <?php endif; ?>
                    
                    <?php if (!empty($config_empresa['bairro'])): ?>
                        <p class="mb-1">
                            <i class="bi bi-house-fill"></i> 
                            <?php echo htmlspecialchars($config_empresa['bairro']); ?>
                        </p>
                    <?php endif; ?>
                    
                    <?php if (!empty($config_empresa['cidade'])): ?>
                        <p class="mb-1">
                            <i class="bi bi-building"></i> 
                            <?php echo htmlspecialchars($config_empresa['cidade']); ?>
                            <?php echo !empty($config_empresa['cep']) ? ' - CEP: ' . htmlspecialchars($config_empresa['cep']) : ''; ?>
                        </p>
                    <?php endif; ?>
                    
                    <?php if (!empty($config_empresa['cnpj'])): ?>
                        <p class="mb-1">
                            <i class="bi bi-card-text"></i> 
                            CNPJ: <?php echo htmlspecialchars($config_empresa['cnpj']); ?>
                        </p>
                    <?php endif; ?>
                </address>
            </div>
            
            <div class="col-12 col-md-4">
                <h5>Contato</h5>
                <?php if (!empty($config_empresa['email'])): ?>
                    <p class="mb-2">
                        <a href="mailto:<?php echo htmlspecialchars($config_empresa['email']); ?>" class="text-decoration-none">
                            <i class="bi bi-envelope-fill"></i> 
                            <?php echo htmlspecialchars($config_empresa['email']); ?>
                        </a>
                    </p>
                <?php endif; ?>
                
                <?php if (!empty($config_empresa['celular'])): ?>
                    <p class="mb-2">
                        <a href="tel:<?php echo preg_replace('/[^0-9]/', '', $config_empresa['celular']); ?>" class="text-decoration-none">
                            <i class="bi bi-telephone-fill"></i>
                            <?php echo htmlspecialchars($config_empresa['celular']); ?>
                        </a>
                    </p>
                <?php endif; ?>
            </div>
            
            <div class="col-12 col-md-4">
                <h5>Redes Sociais</h5>
                <div class="social-links">
                    <?php if (!empty($config_empresa['instagram'])): ?>
                        <a href="<?php echo htmlspecialchars($config_empresa['instagram']); ?>" target="_blank" class="me-3">
                            <i class="bi bi-instagram"></i>
                        </a>
                    <?php endif; ?>
                    
                    <?php if (!empty($config_empresa['facebook'])): ?>
                        <a href="<?php echo htmlspecialchars($config_empresa['facebook']); ?>" target="_blank" class="me-3">
                            <i class="bi bi-facebook"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="row mt-4">
            <div class="col-12">
                <hr>
                <p class="text-center mb-0">
                    &copy; <?php echo date('Y'); ?> <?php echo htmlspecialchars($config_empresa['nome'] ?? 'Minha Loja'); ?>. 
                    Todos os direitos reservados.
                </p>
            </div>
        </div>
    </div>
</footer>

<!-- Botão flutuante do WhatsApp -->
<?php if (!empty($config_empresa['celular'])): ?>
    <a href="https://wa.me/55<?php echo preg_replace('/[^0-9]/', '', $config_empresa['celular']); ?>" 
       class="whatsapp-float" 
       target="_blank">
        <i class="bi bi-whatsapp"></i>
    </a>
<?php endif; ?>
