<?php
require_once 'includes/auth.php';
require_once 'config/database.php';

// Verificar se o usuário está logado
if (!isset($_SESSION['usuario_id'])) {
    die('Você precisa estar logado para acessar esta página.');
}

// Verificar se tem permissão de configurações
try {
    $database = new Database();
    $db = $database->getConnection();
    
    $query = "SELECT permissoes FROM usuarios WHERE id = :id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(":id", $_SESSION['usuario_id']);
    $stmt->execute();
    
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$usuario) {
        die('Usuário não encontrado.');
    }
    
    $permissoes = json_decode($usuario['permissoes'], true);
    if (!$permissoes || !in_array('configuracoes', $permissoes)) {
        die('Acesso negado. Apenas usuários com permissão de configurações podem acessar esta página.');
    }
} catch (Exception $e) {
    die('Erro ao verificar permissões: ' . $e->getMessage());
}

// Confirmar a ação
if (!isset($_POST['confirmar'])) {
    ?>
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Limpar Sistema</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body>
        <div class="container mt-5">
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title text-danger">⚠️ Atenção!</h3>
                    <p class="card-text">
                        Esta ação irá limpar todos os dados do sistema, incluindo:
                        <ul>
                            <li>Vendas e histórico de operações</li>
                            <li>Produtos e categorias</li>
                            <li>Clientes</li>
                            <li>Movimentações do caixa</li>
                            <li>Campanhas de marketing</li>
                            <li>Provas e detalhes</li>
                        </ul>
                        <strong>Esta ação não pode ser desfeita!</strong>
                    </p>
                    <form method="POST" class="mt-4">
                        <input type="hidden" name="confirmar" value="1">
                        <a href="index.php" class="btn btn-secondary">Cancelar</a>
                        <button type="submit" class="btn btn-danger">Confirmar Limpeza</button>
                    </form>
                </div>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit;
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Array com todas as tabelas que serão limpas
    $tabelas = [
        'vendas_itens',
        'vendas',
        'pagamentos',
        'pagamentos_crediario',
        'operacoes',
        'produtos',
        'categorias',
        'estoque_movimentacao',
        'clientes',
        'caixa',
        'caixa_movimentacao',
        'marketing_campanhas',
        'provas',
        'provas_detalhes'
    ];
    
    // Desabilitar verificação de chaves estrangeiras
    $db->exec("SET FOREIGN_KEY_CHECKS = 0");
    
    echo "<div style='margin: 20px; font-family: Arial;'>";
    echo "<h2>Processo de Limpeza</h2>";
    
    // Limpar cada tabela
    foreach ($tabelas as $tabela) {
        try {
            // Verificar se a tabela existe
            $stmt = $db->query("SHOW TABLES LIKE '$tabela'");
            if ($stmt->rowCount() > 0) {
                $db->exec("TRUNCATE TABLE $tabela");
                echo "<p style='color: green'>✓ Tabela $tabela limpa com sucesso</p>";
            } else {
                echo "<p style='color: orange'>⚠ Tabela $tabela não encontrada</p>";
            }
        } catch (Exception $e) {
            echo "<p style='color: red'>✗ Erro ao limpar tabela $tabela: " . $e->getMessage() . "</p>";
        }
    }
    
    // Resetar auto_increment
    foreach ($tabelas as $tabela) {
        try {
            $stmt = $db->query("SHOW TABLES LIKE '$tabela'");
            if ($stmt->rowCount() > 0) {
                $db->exec("ALTER TABLE $tabela AUTO_INCREMENT = 1");
                echo "<p style='color: green'>✓ Auto_increment da tabela $tabela resetado</p>";
            }
        } catch (Exception $e) {
            echo "<p style='color: orange'>⚠ Não foi possível resetar auto_increment da tabela $tabela</p>";
        }
    }
    
    // Habilitar verificação de chaves estrangeiras
    $db->exec("SET FOREIGN_KEY_CHECKS = 1");
    
    echo "<p style='margin-top: 20px'><strong>Processo concluído!</strong></p>";
    echo "<p><a href='index.php' class='btn btn-primary' style='text-decoration: none; padding: 10px 20px; background-color: #007bff; color: white; border-radius: 5px;'>Voltar para o início</a></p>";
    echo "</div>";
    
    // Registrar log
    $usuario_id = $_SESSION['usuario_id'];
    $log_message = "Sistema limpo pelo usuário ID: " . $usuario_id;
    error_log($log_message);
    
} catch (Exception $e) {
    echo "<div style='margin: 20px; color: red; font-family: Arial;'>";
    echo "<h2>Erro ao limpar sistema</h2>";
    echo "<p>" . $e->getMessage() . "</p>";
    echo "<p><a href='index.php' style='text-decoration: none; padding: 10px 20px; background-color: #dc3545; color: white; border-radius: 5px;'>Voltar para o início</a></p>";
    echo "</div>";
    error_log("Erro ao limpar sistema: " . $e->getMessage());
}
