<?php
// Verificar se já está instalado
if (file_exists('installed.txt')) {
    header('Location: index.php');
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'];
    $db_user = $_POST['db_user'];
    $db_pass = $_POST['db_pass'];
    $db_name = $_POST['db_name'];
    
    try {
        // Tenta conectar ao banco
        $conn = new PDO("mysql:host=$db_host", $db_user, $db_pass);
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Criar banco se não existir
        $conn->exec("CREATE DATABASE IF NOT EXISTS `$db_name` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        
        // Seleciona o banco
        $conn->exec("USE `$db_name`");
        
        // Cria os diretórios necessários
        $directories = ['includes', 'config', 'uploads', 'logs'];
        foreach ($directories as $dir) {
            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }
        }

        // 1. Atualiza includes/config.php (arquivo principal de configuração)
        $config_content = "<?php
// Configurações do Banco de Dados
define('DB_HOST', '$db_host');
define('DB_NAME', '$db_name');
define('DB_USER', '$db_user');
define('DB_PASS', '$db_pass');

// Configurações de URL e Upload
\$script_name = \$_SERVER['SCRIPT_NAME'];
\$base_folder = trim(dirname(\$script_name), '/');
\$protocol = isset(\$_SERVER['HTTPS']) && \$_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
define('SITE_URL', \$protocol . \$_SERVER['HTTP_HOST'] . '/' . \$base_folder);
define('UPLOAD_DIR', \$_SERVER['DOCUMENT_ROOT'] . '/' . \$base_folder . '/uploads');

// Conexão com o banco de dados usando PDO
function getConnection() {
    try {
        \$dsn = \"mysql:host=\" . DB_HOST . \";dbname=\" . DB_NAME . \";charset=utf8mb4\";
        \$options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ];
        
        return new PDO(\$dsn, DB_USER, DB_PASS, \$options);
    } catch (PDOException \$e) {
        error_log(\$e->getMessage());
        throw new Exception(\"Erro ao conectar ao banco de dados\");
    }
}

// Configuração de timezone
date_default_timezone_set('America/Sao_Paulo');

// Configuração de sessão
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Ativar exibição de erros do PHP
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configurar log de erros
ini_set('log_errors', 1);
ini_set('error_log', dirname(__DIR__) . '/logs/php_error.log');

// Criar pasta de logs se não existir
\$logDir = dirname(__DIR__) . '/logs';
if (!file_exists(\$logDir)) {
    mkdir(\$logDir, 0777, true);
}";

        // 1. Atualiza config/database.php
        $database_content = "<?php
class Database {
    private \$host = '$db_host';
    private \$db_name = '$db_name';
    private \$username = '$db_user';
    private \$password = '$db_pass';
    public \$conn;
    
    public function getConnection() {
        \$this->conn = null;
        try {
            \$this->conn = new PDO('mysql:host=' . \$this->host . ';dbname=' . \$this->db_name, \$this->username, \$this->password);
            \$this->conn->exec('set names utf8');
        } catch(PDOException \$exception) {
            echo 'Connection error: ' . \$exception->getMessage();
        }
        return \$this->conn;
    }
}";

        // 2. Atualiza config/conexao.php
        $conexao_config_content = "<?php
function getConnection() {
    \$host = '$db_host';
    \$db   = '$db_name';
    \$user = '$db_user';
    \$pass = '$db_pass';
    \$charset = 'utf8mb4';

    \$dsn = \"mysql:host=\$host;dbname=\$db;charset=\$charset\";
    \$options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    try {
        return new PDO(\$dsn, \$user, \$pass, \$options);
    } catch (\\PDOException \$e) {
        throw new \\PDOException(\$e->getMessage(), (int)\$e->getCode());
    }
}";

        // 2. Atualiza includes/conexao.php (usa a função do config.php)
        $conexao_content = "<?php
require_once __DIR__ . '/config.php';

try {
    \$pdo = getConnection();
} catch (PDOException \$e) {
    die(\"Erro ao conectar: \" . \$e->getMessage());
}";

        // 3. Atualiza includes/auth.php
        $auth_content = "<?php
// Se a sessão não estiver iniciada, inicia
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function isLoggedIn() {
    return isset(\$_SESSION['user_id']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        \$current_url = urlencode(\$_SERVER['REQUEST_URI']);
        header(\"Location: login.php?redirect={\$current_url}\");
        exit;
    }
}

function logout() {
    session_destroy();
    header('Location: login.php');
    exit;
}";

        // Cria diretório config se não existir
        if (!file_exists('config')) {
            mkdir('config', 0777, true);
        }

        // Salva todos os arquivos de configuração
        file_put_contents('includes/config.php', $config_content);
        file_put_contents('includes/conexao.php', $conexao_content);
        file_put_contents('includes/auth.php', $auth_content);
        file_put_contents('config/database.php', $database_content);
        file_put_contents('config/conexao.php', $conexao_config_content);

        // Verifica e importa o SQL inicial
        $sql_file = 'sql/bkp_full.sql';
        if (!file_exists($sql_file)) {
            throw new Exception("Arquivo SQL não encontrado em: $sql_file - Por favor, verifique se a pasta 'sql' existe e se o arquivo bkp_full.sql está dentro dela.");
        }
        
        $sql = file_get_contents($sql_file);
        if (!$sql) {
            throw new Exception("Não foi possível ler o arquivo SQL: $sql_file");
        }
        
        // Executa o SQL com tratamento de erros
        try {
            $conn->exec($sql);
        } catch (PDOException $e) {
            throw new Exception("Erro ao importar o SQL: " . $e->getMessage());
        }

        // Cria o arquivo installed.txt
        file_put_contents('installed.txt', date('Y-m-d H:i:s'));

        $success = '<div class="text-center">
                      <h4 class="mb-4" style="color: var(--primary-color);">Sistema instalado com sucesso!</h4>
                      <div class="mb-4">
                          <p class="mb-3">Use as seguintes credenciais para acessar:</p>
                          <div class="p-3" style="background: rgba(0,0,0,0.05); border-radius: 10px;">
                              <p class="mb-2"><strong>Usuário:</strong> admin</p>
                              <p class="mb-0"><strong>Senha:</strong> admin123</p>
                          </div>
                      </div>
                      <p class="text-muted mb-0">Você será redirecionado para a tela de login em instantes...</p>
                   </div>';

        header("Refresh: 5; url=index.php");
    } catch(Exception $e) {
        $error = "Erro na instalação: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalação - Sistema</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="assets/css/install.css" rel="stylesheet">
</head>
<body>
    <div class="install-container">
        <div class="install-card">
            <h1 class="install-title">Instalação do Sistema</h1>

            <?php if ($error): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $error; ?>
            </div>
            <?php endif; ?>

            <?php if ($success): ?>
            <div class="alert alert-success" role="alert">
                <?php echo $success; ?>
            </div>
            <?php else: ?>
            <form method="POST">
                <div class="form-floating mb-3">
                    <input type="text" class="form-control" id="db_host" name="db_host" value="localhost" placeholder="Servidor" required>
                    <label for="db_host">Servidor</label>
                </div>

                <div class="form-floating mb-3">
                    <input type="text" class="form-control" id="db_name" name="db_name" value="<?php echo basename(__DIR__); ?>" placeholder="Nome do Banco de Dados" required>
                    <label for="db_name">Nome do Banco de Dados</label>
                </div>

                <div class="form-floating mb-3">
                    <input type="text" class="form-control" id="db_user" name="db_user" placeholder="Usuário do Banco de Dados" required>
                    <label for="db_user">Usuário do Banco de Dados</label>
                </div>

                <div class="form-floating mb-4">
                    <input type="password" class="form-control" id="db_pass" name="db_pass" placeholder="Senha do Banco de Dados">
                    <label for="db_pass">Senha do Banco de Dados</label>
                </div>

                <button type="submit" class="btn btn-primary">
                    Instalar Sistema
                </button>
            </form>
            <?php endif; ?>
        </div>
    </div>

    <footer class="footer">
        <?php echo date('Y'); ?> 
        <span class="footer-separator">|</span> 
        Feito com <span style="color: #fff;">♥</span> por <a href="https://digin.com.br/" target="_blank">Digin - Sistemas Inteligentes</a> 
        <span class="footer-separator">|</span> 
        Todos os direitos reservados
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
