<?php
session_start();

function verificarPermissao($paginaAtual) {
    // Se não estiver logado, redireciona para o login
    if (!isset($_SESSION['usuario_id'])) {
        header('Location: login.php');
        exit;
    }

    $permissoesPaginas = [
        'dashboard.php' => ['dashboard'],
        'clientes.php' => ['clientes'],
        'produtos.php' => ['produtos'],
        'pdv.php' => ['pdv'],
        'caixa.php' => ['caixa'],
        'vendas.php' => ['vendas'],
        'provas.php' => ['provas'],
        'relatorios.php' => ['relatorios'],
        'usuarios.php' => ['usuarios'],
        'configuracoes.php' => ['configuracoes']
    ];

    $arquivoAtual = basename($paginaAtual);

    // Se a página atual não estiver no array de permissões
    if (!isset($permissoesPaginas[$arquivoAtual])) {
        return true; // Permite acesso a páginas que não precisam de permissão específica
    }

    $permissoesNecessarias = $permissoesPaginas[$arquivoAtual];
    $permissoesUsuario = isset($_SESSION['permissoes']) ? 
                         (is_array($_SESSION['permissoes']) ? 
                          $_SESSION['permissoes'] : 
                          explode(',', $_SESSION['permissoes'])) : 
                         [];

    $temPermissao = false;
    foreach ($permissoesNecessarias as $permissao) {
        if (in_array($permissao, $permissoesUsuario)) {
            $temPermissao = true;
            break;
        }
    }

    if (!$temPermissao) {
        // Se estiver logado mas não tem permissão, mostra página de erro
        require_once 'erro_permissao.php';
        exit;
    }

    return true;
}