<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verifica se está na página de login
$isLoginPage = basename($_SERVER['PHP_SELF']) === 'login.php';

// Se não for a página de login, verifica autenticação
if (!$isLoginPage) {
    if (!isset($_SESSION['usuario_id'])) {
        $current_url = urlencode($_SERVER['REQUEST_URI']);
        header("Location: login.php?redirect=$current_url");
        exit;
    }

    // Verifica se a sessão não expirou
    if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > 1800)) {
        session_unset();
        session_destroy();
        header('Location: login.php?erro=sessao_expirada');
        exit;
    }

    // Atualiza o timestamp da última atividade
    $_SESSION['LAST_ACTIVITY'] = time();
}

// Função para formatar texto em Title Case
function formatarTitleCase($texto) {
    // Converte o texto para minúsculo primeiro
    $texto = mb_strtolower($texto, 'UTF-8');
    
    // Divide o texto em palavras
    $palavras = explode(' ', $texto);
    
    // Lista de palavras que não devem ser capitalizadas
    $excecoes = ['de', 'da', 'do', 'das', 'dos', 'e', 'em', 'com', 'para'];
    
    // Processa cada palavra
    foreach ($palavras as $key => $palavra) {
        // Primeira palavra ou palavras que não são exceções
        if ($key === 0 || !in_array($palavra, $excecoes)) {
            $palavras[$key] = mb_convert_case($palavra, MB_CASE_TITLE, 'UTF-8');
        }
    }
    
    // Junta as palavras novamente
    return implode(' ', $palavras);
}

// Pega o nome da pasta atual
$current_folder = basename(dirname(__DIR__));

// Carrega configurações da empresa
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';

try {
    $pdo = getConnection();
    
    // Busca o nome da empresa da tabela config_empresa
    $stmt = $pdo->query("SELECT nome_empresa FROM config_empresa LIMIT 1");
    $config_empresa = $stmt->fetch(PDO::FETCH_ASSOC);
    $empresa_nome = $config_empresa['nome_empresa'];
    
} catch (Exception $e) {
    error_log("Erro ao buscar configurações da empresa: " . $e->getMessage());
    $empresa_nome = '';
}

// Formata o nome da empresa se existir
if (!empty($empresa_nome)) {
    $empresa_nome = ucwords(mb_strtolower($empresa_nome, 'UTF-8'));
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle : ''; ?><?php echo !empty($empresa_nome) ? ' - ' . htmlspecialchars($empresa_nome) : ''; ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo SITE_URL; ?>/favicon.png">
    <link rel="shortcut icon" type="image/png" href="<?php echo SITE_URL; ?>/favicon.png">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <!-- DataTables -->
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <!-- Toastr CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/theme.css" rel="stylesheet">
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- DataTables -->
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <!-- jQuery Mask Plugin -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <!-- Moment.js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/locale/pt-br.min.js"></script>
    <!-- Toastr JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
    <!-- Delete Modal JS -->
    <script src="assets/js/delete-modal.js"></script>
</head>
<body>

<!-- Toast Container -->
<div class="toast-container position-fixed bottom-0 end-0 p-3"></div>

<!-- Modal de Confirmação de Exclusão -->
<div class="modal fade" id="modalConfirmarExclusao">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" style="color: var(--tertiary-color);">Confirmar Exclusão</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja excluir este item? Esta ação não pode ser desfeita.</p>
                <input type="hidden" id="excluir_cliente_id">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-danger" id="btnConfirmarExclusao">
                    <i class="bi bi-trash"></i> Excluir
                </button>
            </div>
        </div>
    </div>
</div>