<?php
// Configurações do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'digin_garotabonita');
define('DB_USER', 'digin_garotabonita');
define('DB_PASS', 'Girino2025*/');

// Configurações de URL e Upload
$script_name = $_SERVER['SCRIPT_NAME'];
$base_folder = trim(dirname($script_name), '/');
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
define('SITE_URL', $protocol . $_SERVER['HTTP_HOST'] . '/' . $base_folder);
define('UPLOAD_DIR', $_SERVER['DOCUMENT_ROOT'] . '/' . $base_folder . '/uploads');

// Conexão com o banco de dados usando PDO
function getConnection() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ];
        
        return new PDO($dsn, DB_USER, DB_PASS, $options);
    } catch (PDOException $e) {
        error_log($e->getMessage());
        throw new Exception("Erro ao conectar ao banco de dados");
    }
}

// Configuração de timezone
date_default_timezone_set('America/Sao_Paulo');

// Configuração de sessão
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Ativar exibição de erros do PHP
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configurar log de erros
ini_set('log_errors', 1);
ini_set('error_log', dirname(__DIR__) . '/logs/php_error.log');

// Criar pasta de logs se não existir
$logDir = dirname(__DIR__) . '/logs';
if (!file_exists($logDir)) {
    mkdir($logDir, 0777, true);
}