<?php
// Se a sessão não estiver iniciada, inicia
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        $current_url = urlencode($_SERVER['REQUEST_URI']);
        header("Location: login.php?redirect={$current_url}");
        exit;
    }
}

function logout() {
    session_destroy();
    header('Location: login.php');
    exit;
}