<?php
require_once 'config/database.php';
$pageTitle = "Histórico de Alterações";
include 'includes/header.php';
?>

<div class="wrapper">
    <?php include 'includes/sidebar.php'; ?>
    
    <div id="content">
        <nav class="navbar navbar-expand-lg">
            <div class="container-fluid">
                <h2 class="navbar-title">Histórico de Alterações</h2>
            </div>
        </nav>

        <div class="container-fluid content-area">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover" id="historicoTable">
                            <thead>
                                <tr>
                                    <th>Data/Hora</th>
                                    <th>Tipo</th>
                                    <th>Descrição</th>
                                    <th>IP</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Dados serão carregados via AJAX -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Detalhes -->
<div class="modal fade" id="detalhesModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detalhes da Alteração</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="configDetails"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-warning" id="btnReverter">Reverter para esta versão</button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Inicializar DataTable
    const table = $('#historicoTable').DataTable({
        ajax: {
            url: 'actions/get_history.php',
            dataSrc: 'data'
        },
        columns: [
            { 
                data: 'created_at',
                render: function(data) {
                    return moment(data).format('DD/MM/YYYY HH:mm:ss');
                }
            },
            { 
                data: 'config_type',
                render: function(data) {
                    const types = {
                        'empresa': 'Empresa',
                        'redes_sociais': 'Redes Sociais',
                        'estilo': 'Cores do Tema',
                        'empresa_logo': 'Logo da Empresa'
                    };
                    return types[data] || data;
                }
            },
            { data: 'description' },
            { data: 'ip_address' },
            {
                data: null,
                render: function(data) {
                    return `
                        <button class="btn btn-sm btn-info btn-detalhes" data-id="${data.id}">
                            <i class="bi bi-eye"></i>
                        </button>
                    `;
                }
            }
        ],
        order: [[0, 'desc']],
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json'
        }
    });

    // Visualizar detalhes
    $('#historicoTable').on('click', '.btn-detalhes', function() {
        const id = $(this).data('id');
        $.get('actions/get_history_details.php', { id: id }, function(response) {
            if (response.success) {
                const data = JSON.parse(response.data.config_data);
                let html = '<div class="table-responsive"><table class="table">';
                
                for (const [key, value] of Object.entries(data)) {
                    html += `
                        <tr>
                            <th>${key}</th>
                            <td>${value}</td>
                        </tr>
                    `;
                }
                
                html += '</table></div>';
                $('#configDetails').html(html);
                $('#btnReverter').data('hash', response.data.revert_hash);
                $('#detalhesModal').modal('show');
            }
        });
    });

    // Reverter configuração
    $('#btnReverter').on('click', function() {
        const hash = $(this).data('hash');
        if (confirm('Tem certeza que deseja reverter para esta versão?')) {
            $.post('actions/revert_config.php', { hash: hash }, function(response) {
                if (response.success) {
                    showToast('Configuração revertida com sucesso!');
                    $('#detalhesModal').modal('hide');
                    table.ajax.reload();
                } else {
                    showToast(response.message || 'Erro ao reverter configuração', 'error');
                }
            });
        }
    });
});
</script>

<?php include 'includes/footer.php'; ?>
