<?php
if (!isset($_SESSION)) {
    session_start();
}

// Determina o caminho base
function getBaseUrl() {
    $scriptDir = dirname($_SERVER['SCRIPT_NAME']);
    $baseUrl = "";
    
    // Se não estiver na raiz
    if ($scriptDir != '/') {
        // Remove barras duplicadas e trailing slash
        $baseUrl = rtrim($scriptDir, '/');
    }
    
    return $baseUrl;
}

$baseUrl = getBaseUrl();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Erro de Permissão</title>
    <link href="<?php echo $baseUrl; ?>/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo $baseUrl; ?>/assets/css/bootstrap-icons.css" rel="stylesheet">
    <link href="<?php echo $baseUrl; ?>/assets/css/styles.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #ff4d4d 0%, #850000 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .error-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            padding: 3rem;
            text-align: center;
            max-width: 500px;
            width: 90%;
            margin: 20px;
        }
        .error-icon {
            font-size: 8rem;
            color: #ff4d4d;
            margin-bottom: 1.5rem;
            display: inline-block;
            animation: floatIcon 3s ease-in-out infinite;
        }
        @keyframes floatIcon {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-20px);
            }
        }
        .error-title {
            color: #333;
            font-size: 2.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        .error-message {
            color: #666;
            font-size: 1.1rem;
            margin-bottom: 2rem;
            line-height: 1.6;
        }
        .btn-voltar {
            background: linear-gradient(135deg, #ff4d4d 0%, #cc0000 100%);
            color: white;
            border: none;
            padding: 1rem 3rem;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
        }
        .btn-voltar:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 20px rgba(255,77,77,0.4);
            color: white;
        }
        .btn-voltar:active {
            transform: translateY(-1px);
        }
        .btn-voltar i {
            margin-right: 10px;
        }
    </style>
</head>
<body>
    <div class="error-card">
        <i class="bi bi-shield-lock-fill error-icon"></i>
        <h1 class="error-title">Acesso Negado</h1>
        <p class="error-message">
            Desculpe, você não tem permissão para acessar esta página.<br>
            Por favor, retorne ao sistema.
        </p>
        <a href="<?php echo $baseUrl; ?>/index.php" class="btn-voltar">
            <i class="bi bi-arrow-left-circle"></i>Voltar ao Sistema
        </a>
    </div>
</body>
</html>