<?php
require_once __DIR__ . '/../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // Criar tabela de configurações se não existir
    $sql = "CREATE TABLE IF NOT EXISTS config_empresa (
        id INT AUTO_INCREMENT PRIMARY KEY,
        cor_principal VARCHAR(7) DEFAULT '#1923ae',
        cor_secundaria VARCHAR(7) DEFAULT '#b88700',
        cor_texto VARCHAR(7) DEFAULT '#166053',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";

    $db->exec($sql);

    // Inserir valores padrão se a tabela estiver vazia
    $check = "SELECT COUNT(*) FROM config_empresa";
    $count = $db->query($check)->fetchColumn();

    if ($count == 0) {
        $insert = "INSERT INTO config_empresa (cor_principal, cor_secundaria, cor_texto) 
                  VALUES ('#1923ae', '#b88700', '#166053')";
        $db->exec($insert);
    }

    echo "Tabela de configurações criada/atualizada com sucesso!";

} catch(PDOException $e) {
    error_log("Erro ao criar tabela: " . $e->getMessage());
    echo "Erro ao criar tabela de configurações. Verifique os logs para mais detalhes.";
}
?>
