<?php
require_once '../includes/config.php';

try {
    $pdo = getConnection();
    
    // Verifica se a tabela config_site existe
    $stmt = $pdo->query("SHOW TABLES LIKE 'config_site'");
    if ($stmt->rowCount() == 0) {
        // Cria a tabela config_site
        $sql = "CREATE TABLE config_site (
            id INT PRIMARY KEY AUTO_INCREMENT,
            site_ativo TINYINT(1) DEFAULT 1,
            slide_ativo TINYINT(1) DEFAULT 1,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $pdo->exec($sql);
        
        // Insere um registro inicial
        $pdo->exec("INSERT INTO config_site (site_ativo, slide_ativo) VALUES (1, 1)");
        
        echo "Tabela config_site criada com sucesso!\n";
    } else {
        // Verifica se a coluna slide_ativo existe
        $stmt = $pdo->query("SHOW COLUMNS FROM config_site LIKE 'slide_ativo'");
        if ($stmt->rowCount() == 0) {
            // Adiciona a coluna slide_ativo
            $pdo->exec("ALTER TABLE config_site ADD COLUMN slide_ativo TINYINT(1) DEFAULT 1");
            echo "Coluna slide_ativo adicionada com sucesso!\n";
        }
    }
    
} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}
?>
