<?php
require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Adicionar colunas de redes sociais
    $social_columns = [
        'facebook' => 'VARCHAR(255)',
        'instagram' => 'VARCHAR(255)',
        'twitter' => 'VARCHAR(255)',
        'youtube' => 'VARCHAR(255)',
        'linkedin' => 'VARCHAR(255)',
        'whatsapp' => 'VARCHAR(255)'
    ];
    
    // Adicionar colunas de estilo
    $style_columns = [
        'cor_principal' => 'VARCHAR(7)',
        'cor_secundaria' => 'VARCHAR(7)',
        'cor_terciaria' => 'VARCHAR(7)'
    ];
    
    $all_columns = array_merge($social_columns, $style_columns);
    
    foreach ($all_columns as $column => $type) {
        try {
            $sql = "ALTER TABLE config_empresa ADD COLUMN IF NOT EXISTS $column $type DEFAULT NULL";
            $db->exec($sql);
            echo "Coluna '$column' adicionada ou já existe.\n";
        } catch (PDOException $e) {
            if ($e->getCode() == '42S21') { // Código para coluna já existente
                echo "A coluna '$column' já existe na tabela.\n";
            } else {
                echo "Erro ao adicionar coluna '$column': " . $e->getMessage() . "\n";
            }
        }
    }
    
    echo "Processo concluído com sucesso!\n";
    
} catch(PDOException $e) {
    echo "Erro ao conectar com o banco de dados: " . $e->getMessage() . "\n";
}
?>
