<?php
require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Verificar se as colunas existem
    $check_columns = $db->query("SHOW COLUMNS FROM config_empresa WHERE Field IN ('cor_principal', 'cor_secundaria', 'cor_terciaria')");
    $existing_columns = $check_columns->fetchAll(PDO::FETCH_COLUMN);
    
    // Array com as colunas necessárias
    $required_columns = [
        'cor_principal' => "ALTER TABLE config_empresa ADD COLUMN cor_principal VARCHAR(7) DEFAULT '#bd7fbe'",
        'cor_secundaria' => "ALTER TABLE config_empresa ADD COLUMN cor_secundaria VARCHAR(7) DEFAULT '#9c5c9d'",
        'cor_terciaria' => "ALTER TABLE config_empresa ADD COLUMN cor_terciaria VARCHAR(7) DEFAULT '#333333'"
    ];
    
    // Adicionar colunas que não existem
    foreach ($required_columns as $column => $sql) {
        if (!in_array($column, $existing_columns)) {
            $db->exec($sql);
            echo "Coluna $column adicionada com sucesso!\n";
        } else {
            echo "Coluna $column já existe.\n";
        }
    }
    
    echo "Processo concluído com sucesso!";
    
} catch (Exception $e) {
    echo "Erro: " . $e->getMessage();
}
?>
