<?php
require_once 'includes/config.php';

try {
    $pdo = getConnection();
    
    // Verifica a estrutura da tabela operacoes
    $stmt = $pdo->query("DESCRIBE operacoes");
    echo "<h3>Estrutura da tabela operacoes:</h3>";
    echo "<pre>";
    print_r($stmt->fetchAll(PDO::FETCH_ASSOC));
    echo "</pre>";
    
    // Verifica se existem registros
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM operacoes WHERE tipo = 'venda'");
    $total = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
    echo "<h3>Total de vendas em operacoes: " . $total . "</h3>";
    
    if ($total > 0) {
        // Mostra alguns registros
        $stmt = $pdo->query("
            SELECT o.*, c.nome as cliente_nome 
            FROM operacoes o
            LEFT JOIN clientes c ON o.cliente_id = c.id
            WHERE o.tipo = 'venda'
            LIMIT 5
        ");
        echo "<h3>Primeiras 5 vendas:</h3>";
        echo "<pre>";
        print_r($stmt->fetchAll(PDO::FETCH_ASSOC));
        echo "</pre>";
    }
    
} catch (Exception $e) {
    echo "<h3>Erro:</h3>";
    echo "<pre>" . $e->getMessage() . "</pre>";
}
