<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/includes/config.php';

try {
    $pdo = getConnection();
    
    // Verifica os métodos de pagamento únicos
    $query = "SELECT DISTINCT metodo_pagamento FROM operacoes WHERE tipo = 'venda'";
    $stmt = $pdo->query($query);
    $metodos = $stmt->fetchAll(PDO::FETCH_COLUMN);

    echo "<h3>Métodos de pagamento encontrados:</h3>";
    echo "<pre>";
    print_r($metodos);
    echo "</pre>";

    // Mostra algumas vendas com seus métodos
    $query = "SELECT id, metodo_pagamento, valor_total, created_at FROM operacoes WHERE tipo = 'venda' LIMIT 5";
    $stmt = $pdo->query($query);
    $vendas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "<h3>Exemplo de vendas:</h3>";
    echo "<pre>";
    print_r($vendas);
    echo "</pre>";

} catch (Exception $e) {
    echo "<h3>Erro:</h3>";
    echo "<pre>" . $e->getMessage() . "</pre>";
}
