<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Informações do PHP</h2>";
echo "<pre>";
echo "PHP Version: " . phpversion() . "\n";
echo "Display Errors: " . ini_get('display_errors') . "\n";
echo "Error Reporting: " . ini_get('error_reporting') . "\n";
echo "Error Log: " . ini_get('error_log') . "\n";
echo "Upload Max Filesize: " . ini_get('upload_max_filesize') . "\n";
echo "Post Max Size: " . ini_get('post_max_size') . "\n";
echo "Memory Limit: " . ini_get('memory_limit') . "\n";
echo "</pre>";

echo "<h2>Últimos Erros do PHP</h2>";
echo "<pre>";
$error_log = ini_get('error_log');
if (file_exists($error_log)) {
    $errors = file_get_contents($error_log);
    echo htmlspecialchars($errors);
} else {
    echo "Arquivo de log não encontrado em: " . $error_log;
}
echo "</pre>";

echo "<h2>Diretórios e Permissões</h2>";
echo "<pre>";
$dirs = ['uploads', 'logs'];
foreach ($dirs as $dir) {
    if (is_dir($dir)) {
        echo "$dir/: " . substr(sprintf('%o', fileperms($dir)), -4) . "\n";
    } else {
        echo "$dir/: Não existe\n";
    }
}
echo "</pre>";

// Verificar conexão com banco
try {
    $host = 'localhost';
    $db   = 'digin_garota';
    $user = 'digin_garota';
    $pass = 'Girino2024*/';
    $charset = 'utf8mb4';
    
    $dsn = "mysql:host=$host;dbname=$db;charset=$charset";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    
    $pdo = new PDO($dsn, $user, $pass, $options);
    echo "\nConexão com banco de dados: OK";
    
    // Testar uma query simples
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios");
    $result = $stmt->fetch();
    echo "\nTotal de usuários: " . $result['total'];
    
} catch (PDOException $e) {
    echo "\nErro de conexão: " . $e->getMessage();
}
