<?php
require_once 'includes/config.php';

try {
    $pdo = getConnection();
    
    // Verifica a estrutura da tabela vendas
    $stmt = $pdo->query("DESCRIBE vendas");
    echo "<h3>Estrutura da tabela vendas:</h3>";
    echo "<pre>";
    print_r($stmt->fetchAll(PDO::FETCH_ASSOC));
    echo "</pre>";
    
    // Verifica se existem registros
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM vendas");
    $total = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
    echo "<h3>Total de registros em vendas: " . $total . "</h3>";
    
    if ($total > 0) {
        // Mostra alguns registros
        $stmt = $pdo->query("SELECT * FROM vendas LIMIT 5");
        echo "<h3>Primeiros 5 registros:</h3>";
        echo "<pre>";
        print_r($stmt->fetchAll(PDO::FETCH_ASSOC));
        echo "</pre>";
    }
    
    // Verifica a estrutura da tabela pagamentos_parciais
    $stmt = $pdo->query("DESCRIBE pagamentos_parciais");
    echo "<h3>Estrutura da tabela pagamentos_parciais:</h3>";
    echo "<pre>";
    print_r($stmt->fetchAll(PDO::FETCH_ASSOC));
    echo "</pre>";
    
} catch (Exception $e) {
    echo "<h3>Erro:</h3>";
    echo "<pre>" . $e->getMessage() . "</pre>";
}
