<?php
require_once 'includes/verificar_permissao.php';
verificarPermissao(__FILE__);
?>
<?php
$pageTitle = "Caixa";
require_once 'includes/config.php';
require_once 'includes/auth.php';
require_once 'includes/conexao.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: admin/login.php');
    exit;
}

// Verifica se existe um caixa aberto
$stmt = $pdo->prepare("SELECT * FROM caixa WHERE status = 'aberto' ORDER BY id DESC LIMIT 1");
$stmt->execute();
$caixa_aberto = $stmt->fetch(PDO::FETCH_ASSOC);

// Busca o histórico do caixa
$stmt = $pdo->prepare("SELECT * FROM caixa ORDER BY id DESC LIMIT 30");
$stmt->execute();
$historico_caixa = $stmt->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
?>

<div class="wrapper">
    <!-- Sidebar -->
    <?php include 'includes/sidebar.php'; ?>

    <!-- Content -->
    <div id="content">
        <!-- Navbar -->
        <nav class="navbar navbar-expand-lg bg-white">
            <div class="container-fluid">
                <button type="button" id="sidebarCollapse" class="btn btn-link text-purple">
                    <i class="bi bi-list"></i>
                </button>
                <h2 class="navbar-title">Controle de Caixa</h2>
            </div>
        </nav>

        <!-- Content Area -->
        <div class="container-fluid content-area">
            <div class="row">
                <div class="col-12">
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <?php if (!$caixa_aberto): ?>
                                <!-- Formulário para Abrir Caixa -->
                                <form action="actions/abrir_caixa.php" method="POST" class="mb-4">
                                    <div class="row align-items-end">
                                        <div class="col-md-4">
                                            <label for="valor_abertura" class="form-label">Valor Inicial</label>
                                            <div class="input-group">
                                                <span class="input-group-text">R$</span>
                                                <input type="number" step="0.01" class="form-control" id="valor_abertura" name="valor_abertura" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="observacao" class="form-label">Observação</label>
                                            <input type="text" class="form-control" id="observacao" name="observacao">
                                        </div>
                                        <div class="col-md-2">
                                            <button type="submit" class="btn btn-purple w-100">
                                                <i class="bi bi-box-arrow-in-right"></i> Abrir Caixa
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            <?php else: ?>
                                <!-- Formulário para Fechar Caixa -->
                                <form action="actions/fechar_caixa.php" method="POST" class="mb-4">
                                    <input type="hidden" name="caixa_id" value="<?php echo $caixa_aberto['id']; ?>">
                                    <div class="row align-items-end">
                                        <div class="col-md-4">
                                            <label for="valor_fechamento" class="form-label">Valor Final</label>
                                            <div class="input-group">
                                                <span class="input-group-text">R$</span>
                                                <input type="number" step="0.01" class="form-control" id="valor_fechamento" name="valor_fechamento" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="observacao" class="form-label">Observação</label>
                                            <input type="text" class="form-control" id="observacao" name="observacao">
                                        </div>
                                        <div class="col-md-2">
                                            <button type="submit" class="btn btn-danger w-100">
                                                <i class="bi bi-box-arrow-left"></i> Fechar Caixa
                                            </button>
                                        </div>
                                    </div>
                                </form>

                                <!-- Status do Caixa Atual -->
                                <div class="alert alert-purple">
                                    <h6 class="alert-heading">Caixa Atual</h6>
                                    <p class="mb-0">
                                        Aberto em: <?php echo date('d/m/Y H:i', strtotime($caixa_aberto['data_abertura'])); ?><br>
                                        Valor inicial: R$ <?php echo number_format($caixa_aberto['valor_abertura'], 2, ',', '.'); ?>
                                    </p>
                                </div>
                            <?php endif; ?>

                            <!-- Histórico do Caixa -->
                            <h5 class="mt-4 mb-3">Histórico do Caixa</h5>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Status</th>
                                            <th>Abertura</th>
                                            <th>Valor Inicial</th>
                                            <th>Fechamento</th>
                                            <th>Valor Final</th>
                                            <th>Diferença</th>
                                            <th>Observação</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($historico_caixa as $caixa): ?>
                                            <tr>
                                                <td>
                                                    <?php if ($caixa['status'] == 'aberto'): ?>
                                                        <span class="badge bg-purple">Aberto</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-secondary">Fechado</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo date('d/m/Y H:i', strtotime($caixa['data_abertura'])); ?></td>
                                                <td>R$ <?php echo number_format($caixa['valor_abertura'], 2, ',', '.'); ?></td>
                                                <td>
                                                    <?php if ($caixa['data_fechamento']): ?>
                                                        <?php echo date('d/m/Y H:i', strtotime($caixa['data_fechamento'])); ?>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if ($caixa['valor_fechamento']): ?>
                                                        R$ <?php echo number_format($caixa['valor_fechamento'], 2, ',', '.'); ?>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if ($caixa['valor_fechamento']): ?>
                                                        <?php 
                                                        $diferenca = $caixa['valor_fechamento'] - $caixa['valor_abertura'];
                                                        $classe = $diferenca >= 0 ? 'text-success' : 'text-danger';
                                                        ?>
                                                        <span class="<?php echo $classe; ?>">
                                                            R$ <?php echo number_format($diferenca, 2, ',', '.'); ?>
                                                        </span>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo $caixa['observacao'] ?: '-'; ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Toast de Notificação -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 11">
    <div id="notificationToast" class="toast align-items-center text-white border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                <i class="bi bi-info-circle me-2"></i>
                <span id="toastMessage"></span>
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
        </div>
    </div>
</div>

<script>
// Exibir mensagens de sucesso/erro
<?php if (isset($_SESSION['success'])): ?>
    showNotification('<?php echo $_SESSION['success']; ?>', true);
    <?php unset($_SESSION['success']); ?>
<?php endif; ?>

<?php if (isset($_SESSION['error'])): ?>
    showNotification('<?php echo $_SESSION['error']; ?>', false);
    <?php unset($_SESSION['error']); ?>
<?php endif; ?>

// Função para mostrar notificação
function showNotification(message, success = true) {
    const toast = document.getElementById('notificationToast');
    document.getElementById('toastMessage').textContent = message;
    
    toast.classList.remove('bg-success', 'bg-danger');
    toast.classList.add(success ? 'bg-success' : 'bg-danger');
    
    const bsToast = new bootstrap.Toast(toast);
    bsToast.show();
}
</script>

<?php include 'includes/footer.php'; ?>
