// Função para carregar os detalhes da prova
function carregarDetalhesProva(provaId) {
    $.get('actions/get_prova_detalhes.php', { id: provaId }, function(response) {
        if (response.success) {
            const prova = response.data;
            
            // Preenche os detalhes da prova
            $('#clienteNome').text(prova.cliente_nome);
            $('#provaData').text(new Date(prova.created_at).toLocaleDateString('pt-BR'));
            $('#provaValorTotal').text(formatarMoeda(prova.valor_total));
            
            // Preenche a tabela de itens
            let html = '';
            prova.itens.forEach(item => {
                html += `
                    <tr>
                        <td>${item.produto_nome}</td>
                        <td>${item.tamanho}</td>
                        <td>${item.quantidade}</td>
                        <td>${formatarMoeda(item.valor_unitario)}</td>
                        <td>${formatarMoeda(item.valor_unitario * item.quantidade)}</td>
                    </tr>
                `;
            });
            $('#itensProvaTableBody').html(html);
            
            // Configura o botão Finalizar Agora
            $('#btnFinalizarAgora').data('prova-id', provaId);
        }
    });
}

// Função para finalizar a prova e redirecionar para o PDV
function finalizarProva(provaId) {
    // Redireciona para o PDV com o ID da prova
    window.location.href = `pdv.php?prova_id=${provaId}&tipo=venda`;
}

// Adiciona o evento de clique no botão Finalizar Agora
$(document).ready(function() {
    // Carrega os detalhes da prova ao carregar a página
    const urlParams = new URLSearchParams(window.location.search);
    const provaId = urlParams.get('id');
    if (provaId) {
        carregarDetalhesProva(provaId);
    }
    
    // Evento de clique no botão Finalizar Agora
    $('#btnFinalizarAgora').on('click', function() {
        const provaId = $(this).data('prova-id');
        if (provaId) {
            finalizarProva(provaId);
        } else {
            showToast('Erro', 'ID da prova não encontrado!', 'error');
        }
    });
});
