document.addEventListener('DOMContentLoaded', function() {
    // Seleciona todos os checkboxes de filtro
    const filterCheckboxes = document.querySelectorAll('.filter-section input[type="checkbox"]');
    
    // Estado dos filtros
    let activeFilters = {
        cores: [],
        tamanhos: [],
        precos: []
    };

    // Função para atualizar os filtros ativos
    function updateActiveFilters() {
        activeFilters.cores = Array.from(document.querySelectorAll('[id^="cor-"]:checked')).map(cb => cb.value);
        activeFilters.tamanhos = Array.from(document.querySelectorAll('[id^="tam-"]:checked')).map(cb => cb.value);
        activeFilters.precos = Array.from(document.querySelectorAll('[id^="preco-"]:checked')).map(cb => cb.value);
    }

    // Função para verificar se o preço está dentro da faixa selecionada
    function checkPrecoRange(preco, range) {
        const [min, max] = range.split('-').map(v => v === '+' ? Infinity : Number(v));
        return preco >= min && preco <= max;
    }

    // Função para filtrar os produtos
    function filterProducts() {
        updateActiveFilters();
        
        // Seleciona todos os produtos
        const produtos = document.querySelectorAll('.product-card');
        
        produtos.forEach(produto => {
            let showProduct = true;
            
            // Filtro de Cores
            if (activeFilters.cores.length > 0) {
                const corProduto = produto.dataset.cor;
                if (!activeFilters.cores.includes(corProduto)) {
                    showProduct = false;
                }
            }
            
            // Filtro de Tamanhos
            if (showProduct && activeFilters.tamanhos.length > 0) {
                const tamanhosProduto = produto.dataset.tamanhos ? produto.dataset.tamanhos.split(',') : [];
                if (!activeFilters.tamanhos.some(t => tamanhosProduto.includes(t))) {
                    showProduct = false;
                }
            }
            
            // Filtro de Preço
            if (showProduct && activeFilters.precos.length > 0) {
                const precoProduto = parseFloat(produto.dataset.preco);
                if (!activeFilters.precos.some(range => checkPrecoRange(precoProduto, range))) {
                    showProduct = false;
                }
            }
            
            // Mostra ou esconde o produto
            produto.closest('.col').style.display = showProduct ? '' : 'none';
        });

        // Verifica se há produtos visíveis
        const produtosVisiveis = document.querySelectorAll('.product-card:not([style*="display: none"])');
        const mensagemNenhumProduto = document.getElementById('no-products-message');
        
        if (produtosVisiveis.length === 0) {
            if (!mensagemNenhumProduto) {
                const mensagem = document.createElement('div');
                mensagem.id = 'no-products-message';
                mensagem.className = 'col-12 text-center py-5';
                mensagem.innerHTML = `
                    <i class="bi bi-search" style="font-size: 3rem; color: var(--cor-principal);"></i>
                    <h3 class="mt-3">Nenhum produto encontrado</h3>
                    <p class="text-muted">Tente ajustar os filtros para encontrar mais produtos.</p>
                `;
                document.querySelector('.product-grid').appendChild(mensagem);
            }
        } else if (mensagemNenhumProduto) {
            mensagemNenhumProduto.remove();
        }
    }

    // Adiciona evento de change em todos os checkboxes
    filterCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', filterProducts);
    });
});
