$(document).ready(function() {
    // Remove a classe table-responsive
    $('#clientesTable').closest('.table-responsive').removeClass('table-responsive');

    // Inicializa o DataTable
    const table = $('#clientesTable').DataTable({
        ajax: {
            url: 'actions/get_clientes.php',
            dataSrc: function(json) {
                console.log('Resposta recebida:', json);
                if (!json.success) {
                    console.error('Erro ao carregar clientes:', json.message);
                    showToast('Erro ao carregar clientes: ' + json.message, 'error');
                    return [];
                }
                return json.data;
            },
            error: function(xhr, error, thrown) {
                console.error('Erro na requisição:', error, thrown);
                showToast('Erro ao carregar clientes. Por favor, recarregue a página.', 'error');
            }
        },
        columns: [
            {
                data: 'id',
                width: '5%'
            },
            { 
                data: 'nome',
                width: '20%'
            },
            {
                data: 'data_nascimento',
                width: '10%'
            },
            { 
                data: null,
                width: '25%',
                render: function(data, type, row) {
                    let endereco = data.endereco || '';
                    if (endereco.length > 30) {
                        endereco = endereco.substring(0, 27) + '...';
                    }
                    if (data.numero) endereco += ', ' + data.numero;
                    if (data.bairro) {
                        if (data.bairro.length > 30) {
                            endereco += ' - ' + data.bairro.substring(0, 17) + '...';
                        } else {
                            endereco += ' - ' + data.bairro;
                        }
                    }
                    return `<span title="${data.endereco}${data.numero ? ', ' + data.numero : ''}${data.bairro ? ' - ' + data.bairro : ''}">${endereco}</span>`;
                }
            },
            { 
                data: 'cidade',
                width: '10%'
            },
            { 
                data: 'telefone',
                width: '10%'
            },
            { 
                data: 'instagram',
                width: '10%',
                render: function(data, type, row) {
                    return data ? '@' + data : '';
                }
            },
            {
                data: null,
                width: '10%',
                orderable: false,
                render: function(data, type, row) {
                    return `
                        <button class="btn btn-sm btn-primary btn-editar" data-id="${row.id}" type="button">
                            <i class="bi bi-pencil"></i>
                        </button>
                        <button class="btn btn-sm btn-danger btn-excluir" data-id="${row.id}" type="button">
                            <i class="bi bi-trash"></i>
                        </button>
                    `;
                }
            }
        ],
        processing: true,
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados por página",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    // Função para aplicar máscaras
    function aplicarMascaras() {
        $('#telefone').mask('(00) 00000-0000');
        $('#numero').mask('0#');
    }

    // Aplica máscaras inicialmente
    aplicarMascaras();

    // Flag para controlar se é edição ou novo cadastro
    let isEditMode = false;

    // Limpa formulário ao abrir modal para novo cadastro
    $('#modalCadastroCliente').on('show.bs.modal', function(e) {
        // Se não estiver em modo de edição, limpa o formulário
        if (!isEditMode) {
            console.log('Limpando formulário para novo cadastro');
            $('#formCadastroCliente')[0].reset();
            $('#id').val('');
            $('#modalCadastroClienteLabel').text('Cadastrar Cliente');
            aplicarMascaras();
        }
        // Reseta a flag após o modal ser mostrado
        isEditMode = false;
    });

    // Manipula clique no botão editar
    $(document).on('click', '.btn-editar', function(e) {
        e.preventDefault();
        isEditMode = true;
        const id = $(this).data('id');
        
        // Busca os dados do cliente
        $.get('actions/get_cliente.php', { id: id })
            .done(function(response) {
                if (response.success) {
                    const cliente = response.data;
                    $('#id').val(cliente.id);
                    $('#nome').val(cliente.nome);
                    $('#data_nascimento').val(cliente.data_nascimento);
                    $('#endereco').val(cliente.endereco);
                    $('#numero').val(cliente.numero);
                    $('#bairro').val(cliente.bairro);
                    $('#cidade').val(cliente.cidade);
                    $('#telefone').val(cliente.telefone);
                    $('#instagram').val(cliente.instagram);
                    
                    $('#modalCadastroClienteLabel').text('Editar Cliente');
                    $('#modalCadastroCliente').modal('show');
                    aplicarMascaras();
                } else {
                    showToast(response.message || 'Erro ao carregar dados do cliente', 'error');
                }
            })
            .fail(function() {
                showToast('Erro ao carregar dados do cliente', 'error');
            });
    });

    // Inicializa o modal de exclusão com mensagem personalizada para clientes
    initDeleteModal({
        deleteButtonSelector: '.btn-excluir',
        deleteUrl: 'actions/delete_cliente.php',
        reloadCallback: function() {
            table.ajax.reload();
        },
        successMessage: 'Cliente excluído com sucesso!',
        errorMessage: 'Erro ao excluir cliente'
    });

    // Manipula envio do formulário
    $('#formCadastroCliente').on('submit', function(e) {
        e.preventDefault();
        
        const formData = $(this).serialize();
        console.log('Dados do formulário:', formData);
        
        $.post('actions/salvar_cliente.php', formData)
            .done(function(response) {
                console.log('Resposta do servidor:', response);
                
                if (response.success) {
                    $('#modalCadastroCliente').modal('hide');
                    table.ajax.reload();
                    showToast(response.message || 'Cliente salvo com sucesso!');
                } else {
                    console.error('Erro ao salvar:', response.message);
                    showToast(response.message || 'Erro ao salvar cliente', 'error');
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.error('Erro na requisição:', textStatus, errorThrown);
                showToast('Erro ao salvar cliente', 'error');
            });
    });
});
