<?php
require_once '../includes/config.php';

try {
    $pdo = getConnection();
    
    $query = "SELECT o.*, c.nome as cliente_nome, u.nome as vendedor_nome 
              FROM operacoes o 
              LEFT JOIN clientes c ON o.cliente_id = c.id 
              LEFT JOIN usuarios u ON o.usuario_id = u.id 
              WHERE o.tipo = 'venda'
              ORDER BY o.data_operacao DESC";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $vendas = $stmt->fetchAll();
    
    // Formatar dados para o DataTables
    $data = array();
    foreach ($vendas as $venda) {
        $row = array();
        $row[] = $venda['id'];
        $row[] = date('d/m/Y H:i', strtotime($venda['data_operacao']));
        $row[] = $venda['cliente_nome'] ?? 'Cliente não informado';
        $row[] = $venda['vendedor_nome'];
        $row[] = 'R$ ' . number_format($venda['valor_total'], 2, ',', '.');
        $row[] = ucfirst($venda['status']);
        $row[] = '<button class="btn btn-sm btn-info ver-venda" data-id="'.$venda['id'].'">Ver</button> 
                  <button class="btn btn-sm btn-primary editar-venda" data-id="'.$venda['id'].'">Editar</button>';
        $data[] = $row;
    }
    
    echo json_encode(array(
        "draw" => isset($_POST['draw']) ? intval($_POST['draw']) : 0,
        "recordsTotal" => count($vendas),
        "recordsFiltered" => count($vendas),
        "data" => $data
    ));
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(array("error" => "Erro ao carregar vendas: " . $e->getMessage()));
}
