<?php
require_once '../includes/config.php';

if (isset($_GET['id'])) {
    try {
        $pdo = getConnection();
        $id = $_GET['id'];
        
        $query = "SELECT * FROM clientes WHERE id = ?";
        $stmt = $pdo->prepare($query);
        $stmt->execute([$id]);
        $cliente = $stmt->fetch();
        
        if ($cliente) {
            echo json_encode(['success' => true, 'cliente' => $cliente]);
        } else {
            echo json_encode(['success' => false, 'error' => 'Cliente não encontrado']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'error' => 'Erro ao carregar cliente: ' . $e->getMessage()]);
    }
} else {
    // Listar todos os clientes
    try {
        $pdo = getConnection();
        
        $query = "SELECT * FROM clientes ORDER BY nome";
        $stmt = $pdo->prepare($query);
        $stmt->execute();
        $clientes = $stmt->fetchAll();
        
        $data = array();
        foreach ($clientes as $cliente) {
            $row = array();
            $row[] = $cliente['id'];
            $row[] = $cliente['nome'];
            $row[] = $cliente['email'];
            $row[] = $cliente['telefone'];
            $row[] = $cliente['whatsapp'];
            $row[] = '<button class="btn btn-sm btn-primary editar-cliente" data-id="'.$cliente['id'].'">Editar</button> 
                      <button class="btn btn-sm btn-danger excluir-cliente" data-id="'.$cliente['id'].'">Excluir</button>';
            $data[] = $row;
        }
        
        echo json_encode(array(
            "draw" => isset($_POST['draw']) ? intval($_POST['draw']) : 0,
            "recordsTotal" => count($clientes),
            "recordsFiltered" => count($clientes),
            "data" => $data
        ));
        
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao carregar clientes: ' . $e->getMessage()]);
    }
}
