<?php
require_once '../includes/config.php';

try {
    $pdo = getConnection();
    $search = isset($_GET['search']) ? $_GET['search'] : '';
    
    $query = "SELECT p.*, c.nome as categoria_nome, pt.tamanho, pt.quantidade as estoque 
              FROM produtos p 
              LEFT JOIN categorias c ON p.categoria_id = c.id 
              LEFT JOIN produto_tamanhos pt ON p.id = pt.produto_id
              WHERE p.ativo = 1 AND (p.nome LIKE :search OR c.nome LIKE :search)
              ORDER BY p.nome";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute(['search' => "%$search%"]);
    $produtos = $stmt->fetchAll();
    
    $result = array();
    foreach ($produtos as $produto) {
        $item = array(
            'id' => $produto['id'],
            'nome' => $produto['nome'],
            'categoria' => $produto['categoria_nome'],
            'preco' => number_format($produto['preco'], 2, ',', '.'),
            'tamanho' => $produto['tamanho'],
            'estoque' => $produto['estoque']
        );
        $result[] = $item;
    }
    
    echo json_encode(['success' => true, 'produtos' => $result]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro ao buscar produtos: ' . $e->getMessage()]);
}
