<?php
$pageTitle = "Caixa";
require_once '../includes/config.php';
require_once '../includes/auth.php';
include 'header.php';
require_once 'includes/conexao.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: login.php');
    exit;
}

// Verifica se existe um caixa aberto
$stmt = $pdo->prepare("SELECT * FROM caixa WHERE status = 'aberto' ORDER BY id DESC LIMIT 1");
$stmt->execute();
$caixa_aberto = $stmt->fetch(PDO::FETCH_ASSOC);

// Busca o histórico do caixa
$stmt = $pdo->prepare("SELECT * FROM caixa ORDER BY id DESC LIMIT 30");
$stmt->execute();
$historico_caixa = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Controle de Caixa</h5>
                </div>
                <div class="card-body">
                    <?php if (!$caixa_aberto): ?>
                        <!-- Formulário para Abrir Caixa -->
                        <form action="actions/abrir_caixa.php" method="POST" class="mb-4">
                            <div class="row align-items-end">
                                <div class="col-md-4">
                                    <label for="valor_abertura" class="form-label">Valor Inicial</label>
                                    <div class="input-group">
                                        <span class="input-group-text">R$</span>
                                        <input type="number" step="0.01" class="form-control" id="valor_abertura" name="valor_abertura" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="observacao" class="form-label">Observação</label>
                                    <input type="text" class="form-control" id="observacao" name="observacao">
                                </div>
                                <div class="col-md-2">
                                    <button type="submit" class="btn btn-success w-100">
                                        <i class="bi bi-box-arrow-in-right"></i> Abrir Caixa
                                    </button>
                                </div>
                            </div>
                        </form>
                    <?php else: ?>
                        <!-- Formulário para Fechar Caixa -->
                        <form action="actions/fechar_caixa.php" method="POST" class="mb-4">
                            <input type="hidden" name="caixa_id" value="<?php echo $caixa_aberto['id']; ?>">
                            <div class="row align-items-end">
                                <div class="col-md-4">
                                    <label for="valor_fechamento" class="form-label">Valor Final</label>
                                    <div class="input-group">
                                        <span class="input-group-text">R$</span>
                                        <input type="number" step="0.01" class="form-control" id="valor_fechamento" name="valor_fechamento" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="observacao" class="form-label">Observação</label>
                                    <input type="text" class="form-control" id="observacao" name="observacao">
                                </div>
                                <div class="col-md-2">
                                    <button type="submit" class="btn btn-danger w-100">
                                        <i class="bi bi-box-arrow-left"></i> Fechar Caixa
                                    </button>
                                </div>
                            </div>
                        </form>

                        <!-- Status do Caixa Atual -->
                        <div class="alert alert-info">
                            <h6 class="alert-heading">Caixa Atual</h6>
                            <p class="mb-0">
                                Aberto em: <?php echo date('d/m/Y H:i', strtotime($caixa_aberto['data_abertura'])); ?><br>
                                Valor inicial: R$ <?php echo number_format($caixa_aberto['valor_abertura'], 2, ',', '.'); ?>
                            </p>
                        </div>
                    <?php endif; ?>

                    <!-- Histórico do Caixa -->
                    <h5 class="mt-4 mb-3">Histórico do Caixa</h5>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Status</th>
                                    <th>Abertura</th>
                                    <th>Valor Inicial</th>
                                    <th>Fechamento</th>
                                    <th>Valor Final</th>
                                    <th>Diferença</th>
                                    <th>Observação</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($historico_caixa as $caixa): ?>
                                    <tr>
                                        <td>
                                            <?php if ($caixa['status'] == 'aberto'): ?>
                                                <span class="badge bg-success">Aberto</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">Fechado</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo date('d/m/Y H:i', strtotime($caixa['data_abertura'])); ?></td>
                                        <td>R$ <?php echo number_format($caixa['valor_abertura'], 2, ',', '.'); ?></td>
                                        <td>
                                            <?php if ($caixa['data_fechamento']): ?>
                                                <?php echo date('d/m/Y H:i', strtotime($caixa['data_fechamento'])); ?>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($caixa['valor_fechamento']): ?>
                                                R$ <?php echo number_format($caixa['valor_fechamento'], 2, ',', '.'); ?>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($caixa['valor_fechamento']): ?>
                                                <?php 
                                                $diferenca = $caixa['valor_fechamento'] - $caixa['valor_abertura'];
                                                $classe = $diferenca >= 0 ? 'text-success' : 'text-danger';
                                                ?>
                                                <span class="<?php echo $classe; ?>">
                                                    R$ <?php echo number_format($diferenca, 2, ',', '.'); ?>
                                                </span>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $caixa['observacao'] ?: '-'; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
