<?php
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    if (!isset($_FILES['logo'])) {
        throw new Exception('Nenhum arquivo foi enviado');
    }

    $file = $_FILES['logo'];
    $fileName = $file['name'];
    $fileType = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    
    // Verifica o tipo do arquivo
    $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];
    if (!in_array($fileType, $allowedTypes)) {
        throw new Exception('Tipo de arquivo não permitido. Use apenas: ' . implode(', ', $allowedTypes));
    }

    // Verifica o tamanho (máximo 2MB)
    if ($file['size'] > 2 * 1024 * 1024) {
        throw new Exception('O arquivo é muito grande. Tamanho máximo: 2MB');
    }

    // Cria o diretório de upload se não existir
    $uploadDir = '../uploads/';
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // Gera um nome único para o arquivo
    $newFileName = 'logo_' . date('YmdHis') . '.' . $fileType;
    $uploadPath = $uploadDir . $newFileName;

    // Move o arquivo
    if (!move_uploaded_file($file['tmp_name'], $uploadPath)) {
        throw new Exception('Erro ao fazer upload do arquivo');
    }

    // Atualiza no banco de dados
    $database = new Database();
    $db = $database->getConnection();

    $relativePath = 'uploads/' . $newFileName;
    
    $query = "UPDATE config_empresa SET logo = :logo WHERE id = 1";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':logo', $relativePath);
    
    if (!$stmt->execute()) {
        // Se falhar, remove o arquivo
        unlink($uploadPath);
        throw new Exception('Erro ao atualizar o banco de dados');
    }

    // Remove a logo antiga se existir
    $query = "SELECT logo FROM config_empresa WHERE id = 1";
    $stmt = $db->prepare($query);
    if ($stmt->execute()) {
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result && !empty($result['logo'])) {
            $oldLogo = '../' . $result['logo'];
            if (file_exists($oldLogo) && $oldLogo != $uploadPath) {
                unlink($oldLogo);
            }
        }
    }

    echo json_encode([
        'success' => true,
        'message' => 'Logo atualizada com sucesso',
        'path' => $relativePath
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
