<?php
// Desativa a exibição de erros
error_reporting(0);
ini_set('display_errors', 0);

// Garante que nenhum output foi enviado antes
if (ob_get_length()) ob_clean();

require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    // Recebe os dados do formulário
    $nome_empresa = filter_input(INPUT_POST, 'nome_empresa', FILTER_SANITIZE_STRING);
    $cnpj = filter_input(INPUT_POST, 'cnpj', FILTER_SANITIZE_STRING);
    $telefone = filter_input(INPUT_POST, 'telefone', FILTER_SANITIZE_STRING);
    $whatsapp = filter_input(INPUT_POST, 'whatsapp', FILTER_SANITIZE_STRING);
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $instagram = filter_input(INPUT_POST, 'instagram', FILTER_SANITIZE_STRING);
    $endereco = filter_input(INPUT_POST, 'endereco', FILTER_SANITIZE_STRING);
    $numero = filter_input(INPUT_POST, 'numero', FILTER_SANITIZE_STRING);
    $bairro = filter_input(INPUT_POST, 'bairro', FILTER_SANITIZE_STRING);
    $cep = filter_input(INPUT_POST, 'cep', FILTER_SANITIZE_STRING);
    $cidade = filter_input(INPUT_POST, 'cidade', FILTER_SANITIZE_STRING);
    $celular = filter_input(INPUT_POST, 'celular', FILTER_SANITIZE_STRING);

    // Valida dados obrigatórios
    if (empty($nome_empresa)) {
        throw new Exception('O nome da empresa é obrigatório');
    }

    // Verifica se já existe configuração
    $query = "SELECT COUNT(*) FROM config_empresa";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $count = $stmt->fetchColumn();

    if ($count > 0) {
        // Update
        $sql = "UPDATE config_empresa SET 
                nome_empresa = :nome_empresa,
                cnpj = :cnpj,
                telefone = :telefone,
                whatsapp = :whatsapp,
                email = :email,
                instagram = :instagram,
                endereco = :endereco,
                numero = :numero,
                bairro = :bairro,
                cep = :cep,
                cidade = :cidade,
                celular = :celular";
    } else {
        // Insert
        $sql = "INSERT INTO config_empresa 
                (nome_empresa, cnpj, telefone, whatsapp, email, instagram, endereco, 
                numero, bairro, cep, cidade, celular)
                VALUES 
                (:nome_empresa, :cnpj, :telefone, :whatsapp, :email, :instagram, :endereco,
                :numero, :bairro, :cep, :cidade, :celular)";
    }

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':nome_empresa', $nome_empresa);
    $stmt->bindParam(':cnpj', $cnpj);
    $stmt->bindParam(':telefone', $telefone);
    $stmt->bindParam(':whatsapp', $whatsapp);
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':instagram', $instagram);
    $stmt->bindParam(':endereco', $endereco);
    $stmt->bindParam(':numero', $numero);
    $stmt->bindParam(':bairro', $bairro);
    $stmt->bindParam(':cep', $cep);
    $stmt->bindParam(':cidade', $cidade);
    $stmt->bindParam(':celular', $celular);

    if ($stmt->execute()) {
        // Log da operação
        error_log("Configurações da empresa salvas com sucesso. Nome: $nome_empresa");
        
        die(json_encode([
            'success' => true,
            'message' => 'Configurações salvas com sucesso'
        ]));
    } else {
        throw new Exception('Erro ao salvar configurações');
    }
    
} catch (Exception $e) {
    error_log("Erro ao salvar configurações da empresa: " . $e->getMessage());
    die(json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]));
}
