<?php
header('Content-Type: application/json');
require_once '../config/database.php';

try {
    // Validar entrada
    $cor_principal = filter_input(INPUT_POST, 'cor_principal', FILTER_SANITIZE_STRING);
    $cor_secundaria = filter_input(INPUT_POST, 'cor_secundaria', FILTER_SANITIZE_STRING);
    $cor_texto = filter_input(INPUT_POST, 'cor_texto', FILTER_SANITIZE_STRING);

    if (!$cor_principal || !$cor_secundaria || !$cor_texto) {
        throw new Exception('Todas as cores são obrigatórias');
    }

    // Validar formato das cores
    $cor_regex = '/#[0-9a-f]{6}/i';
    if (!preg_match($cor_regex, $cor_principal) || 
        !preg_match($cor_regex, $cor_secundaria) || 
        !preg_match($cor_regex, $cor_texto)) {
        throw new Exception('Formato de cor inválido');
    }

    $database = new Database();
    $db = $database->getConnection();

    // Atualizar ou inserir cores
    $sql = "INSERT INTO config_empresa (cor_principal, cor_secundaria, cor_texto) 
            VALUES (:cor_principal, :cor_secundaria, :cor_texto)
            ON DUPLICATE KEY UPDATE 
            cor_principal = VALUES(cor_principal),
            cor_secundaria = VALUES(cor_secundaria),
            cor_texto = VALUES(cor_texto)";

    $stmt = $db->prepare($sql);
    $stmt->bindParam(':cor_principal', $cor_principal);
    $stmt->bindParam(':cor_secundaria', $cor_secundaria);
    $stmt->bindParam(':cor_texto', $cor_texto);

    if ($stmt->execute()) {
        // Atualizar o arquivo theme.css
        $update_url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/update_theme.php';
        $ch = curl_init($update_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        echo json_encode(['success' => true, 'message' => 'Configurações salvas com sucesso']);
    } else {
        throw new Exception('Erro ao salvar configurações');
    }

} catch (Exception $e) {
    error_log("Erro ao salvar configurações: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
