<?php
require_once '../config/database.php';
require_once '../includes/auth.php';
header('Content-Type: application/json');

try {
    // Validar dados recebidos
    if (empty($_POST['nome'])) {
        throw new Exception('Nome é obrigatório');
    }
    
    // Validar confirmação de senha
    if (!empty($_POST['senha'])) {
        if (empty($_POST['confirmar_senha'])) {
            throw new Exception('Confirmação de senha é obrigatória');
        }
        if ($_POST['senha'] !== $_POST['confirmar_senha']) {
            throw new Exception('As senhas não conferem');
        }
    }
    
    $database = new Database();
    $conn = $database->getConnection();
    
    // Verificar se já existe um usuário com este nome
    $stmt = $conn->prepare("SELECT id FROM usuarios WHERE nome = ? AND id != ?");
    $stmt->execute([$_POST['nome'], $_POST['id'] ?? 0]);
    if ($stmt->fetch()) {
        throw new Exception('Já existe um usuário com este nome');
    }
    
    // Preparar array de permissões
    $permissoes = isset($_POST['permissoes']) ? $_POST['permissoes'] : [];
    
    // Se for o usuário admin, garantir todas as permissões
    if (strtolower($_POST['nome']) === 'admin') {
        $permissoes = ['dashboard', 'clientes', 'produtos', 'pdv', 'caixa', 'vendas', 'provas', 'relatorios', 'marketing', 'usuarios', 'configuracoes'];
        error_log("DEBUG - Salvando usuário admin com todas as permissões");
    }
    
    $permissoes_json = json_encode($permissoes);
    if ($permissoes_json === false) {
        error_log("DEBUG - Erro ao codificar permissões: " . json_last_error_msg());
        throw new Exception('Erro ao processar permissões');
    }
    
    error_log("DEBUG - Permissões a serem salvas: " . $permissoes_json);
    
    // Se for edição
    if (!empty($_POST['id'])) {
        if (!empty($_POST['senha'])) {
            // Atualizar com nova senha
            $senha_hash = password_hash($_POST['senha'], PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE usuarios SET nome = ?, senha = ?, permissoes = ? WHERE id = ?");
            $stmt->execute([$_POST['nome'], $senha_hash, $permissoes_json, $_POST['id']]);
        } else {
            // Atualizar sem mudar a senha
            $stmt = $conn->prepare("UPDATE usuarios SET nome = ?, permissoes = ? WHERE id = ?");
            $stmt->execute([$_POST['nome'], $permissoes_json, $_POST['id']]);
        }
        
        echo json_encode([
            'success' => true,
            'message' => 'Usuário atualizado com sucesso'
        ]);
    }
    // Se for novo usuário
    else {
        if (empty($_POST['senha'])) {
            throw new Exception('Senha é obrigatória para novo usuário');
        }
        
        $senha_hash = password_hash($_POST['senha'], PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO usuarios (nome, senha, permissoes) VALUES (?, ?, ?)");
        $stmt->execute([$_POST['nome'], $senha_hash, $permissoes_json]);
        
        echo json_encode([
            'success' => true,
            'message' => 'Usuário cadastrado com sucesso'
        ]);
    }
    
} catch (Exception $e) {
    error_log("Erro ao salvar usuário: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
