<?php
// Desativa a exibição de erros
error_reporting(0);
ini_set('display_errors', 0);

// Garante que nenhum output foi enviado antes
if (ob_get_length()) ob_clean();

header('Content-Type: application/json');

require_once '../includes/config.php';
require_once '../includes/functions.php';

try {
    // Verifica se é uma requisição POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método não permitido');
    }

    // Obtém os dados do POST
    $dados = json_decode(file_get_contents('php://input'), true);
    if (!$dados) {
        throw new Exception('Dados inválidos');
    }

    // Valida dados obrigatórios
    if (empty($dados['cliente_id'])) {
        throw new Exception('Cliente não selecionado');
    }
    if (empty($dados['tipo'])) {
        throw new Exception('Tipo de operação não selecionado');
    }
    if (empty($dados['itens']) || !is_array($dados['itens'])) {
        throw new Exception('Nenhum item adicionado');
    }

    $pdo = getConnection();
    $pdo->beginTransaction();

    try {
        // Insere a operação
        $query = "INSERT INTO operacoes (cliente_id, tipo, valor_total, created_at) VALUES (?, ?, ?, NOW())";
        $stmt = $pdo->prepare($query);
        $stmt->execute([
            $dados['cliente_id'],
            $dados['tipo'],
            $dados['total']
        ]);
        
        $operacaoId = $pdo->lastInsertId();

        // Insere os itens da operação
        $query = "INSERT INTO operacao_itens (operacao_id, produto_id, tamanho, quantidade, valor_unitario) VALUES (?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($query);
        
        foreach ($dados['itens'] as $item) {
            $stmt->execute([
                $operacaoId,
                $item['id'],
                $item['tamanho'],
                $item['quantidade'],
                $item['valor']
            ]);

            // Se for uma venda, atualiza o estoque
            if ($dados['tipo'] === 'venda') {
                $query_estoque = "UPDATE produto_tamanhos SET estoque = estoque - ? WHERE produto_id = ? AND tamanho = ?";
                $stmt_estoque = $pdo->prepare($query_estoque);
                $stmt_estoque->execute([$item['quantidade'], $item['id'], $item['tamanho']]);
            }
        }

        $pdo->commit();

        die(json_encode([
            'success' => true,
            'message' => 'Operação salva com sucesso',
            'data' => [
                'operacao_id' => $operacaoId
            ]
        ]));

    } catch (Exception $e) {
        $pdo->rollBack();
        throw $e;
    }

} catch (Exception $e) {
    die(json_encode([
        'success' => false,
        'message' => 'Erro ao salvar operação: ' . $e->getMessage()
    ]));
}
