<?php
require_once '../includes/db_connection.php';

try {
    // Inicia a transação
    $conn->begin_transaction();

    // Recebe os dados do POST
    $dados = json_decode(file_get_contents('php://input'), true);
    
    // Insere a operação
    $query = "INSERT INTO operacoes (cliente_id, tipo, valor_total, data_hora) VALUES (?, ?, ?, NOW())";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("isd", $dados['cliente_id'], $dados['tipo'], $dados['total']);
    $stmt->execute();
    $operacao_id = $conn->insert_id;

    // Insere os itens da operação
    $query = "INSERT INTO operacao_items (operacao_id, produto_id, tamanho, quantidade, valor_unitario) VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($query);

    foreach ($dados['items'] as $item) {
        $stmt->bind_param("iisid", 
            $operacao_id,
            $item['id'],
            $item['tamanho'],
            $item['quantidade'],
            $item['valor']
        );
        $stmt->execute();

        // Atualiza o estoque
        $query_estoque = "UPDATE tamanhos SET estoque = estoque - ? WHERE produto_id = ? AND tamanho = ?";
        $stmt_estoque = $conn->prepare($query_estoque);
        $stmt_estoque->bind_param("iis", $item['quantidade'], $item['id'], $item['tamanho']);
        $stmt_estoque->execute();
    }

    // Se for uma venda, registra no financeiro
    if ($dados['tipo'] === 'venda') {
        $query = "INSERT INTO financeiro (operacao_id, tipo, valor, data) VALUES (?, 'entrada', ?, NOW())";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("id", $operacao_id, $dados['total']);
        $stmt->execute();
    }

    // Commit da transação
    $conn->commit();

    echo json_encode([
        'status' => 'success',
        'message' => $dados['tipo'] === 'venda' ? 'Venda realizada com sucesso!' : 'Prova registrada com sucesso!'
    ]);

} catch (Exception $e) {
    // Rollback em caso de erro
    $conn->rollback();
    
    echo json_encode([
        'status' => 'error',
        'message' => 'Erro ao salvar a operação: ' . $e->getMessage()
    ]);
}
