<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    // Primeiro, pega o nome da imagem atual
    $stmt = $pdo->query("SELECT slide_image FROM config_site LIMIT 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($config && !empty($config['slide_image'])) {
        // Caminho do arquivo
        $imagePath = __DIR__ . '/../uploads/slides/' . $config['slide_image'];
        
        // Remove o arquivo se ele existir
        if (file_exists($imagePath)) {
            unlink($imagePath);
        }
        
        // Limpa o campo no banco de dados
        $stmt = $pdo->prepare("UPDATE config_site SET slide_image = NULL WHERE slide_image = ?");
        $stmt->execute([$config['slide_image']]);
        
        echo json_encode([
            'success' => true,
            'message' => 'Imagem removida com sucesso'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Nenhuma imagem encontrada'
        ]);
    }
    
} catch (Exception $e) {
    error_log("Erro ao remover imagem do slide: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao remover imagem: ' . $e->getMessage()
    ]);
}
